/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.Vein;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Axis;
import org.bukkit.Effect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class LumberAxe
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private static final int MAX_BROKEN = 100;
    private static final int MAX_STRIPPED = 20;

    public LumberAxe(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (MaterialCollections.getAllLogs().contains(e.getBlock().getType()) && LumberAxe.this.isItem(item)) {
                    if (!Slimefun.hasUnlocked(e.getPlayer(), LumberAxe.this, true)) {
                        return true;
                    }
                    List<Block> logs = Vein.find(e.getBlock(), 100, b -> MaterialCollections.getAllLogs().contains(b.getType()));
                    if (logs.contains(e.getBlock())) {
                        logs.remove(e.getBlock());
                    }
                    for (Block b2 : logs) {
                        if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b2, ProtectableAction.BREAK_BLOCK)) continue;
                        LumberAxe.this.breakLog(b2);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Block block;
            if (e.getClickedBlock().isPresent() && this.isUnstrippedLog(block = e.getClickedBlock().get())) {
                List<Block> logs = Vein.find(block, 20, this::isUnstrippedLog);
                if (logs.contains(block)) {
                    logs.remove(block);
                }
                for (Block b : logs) {
                    if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b, ProtectableAction.BREAK_BLOCK)) continue;
                    this.stripLog(b);
                }
            }
        };
    }

    private boolean isUnstrippedLog(Block block) {
        return Tag.LOGS.isTagged((Keyed)block.getType()) && !block.getType().name().startsWith("STRIPPED_");
    }

    private void stripLog(Block b) {
        b.getWorld().playSound(b.getLocation(), Sound.ITEM_AXE_STRIP, 1.0f, 1.0f);
        Axis axis = ((Orientable)b.getBlockData()).getAxis();
        b.setType(Material.valueOf((String)("STRIPPED_" + b.getType().name())));
        Orientable orientable = (Orientable)b.getBlockData();
        orientable.setAxis(axis);
        b.setBlockData((BlockData)orientable);
    }

    private void breakLog(Block b) {
        b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
        for (ItemStack drop : b.getDrops(this.getItem())) {
            b.getWorld().dropItemNaturally(b.getLocation(), drop);
        }
        b.setType(Material.AIR);
    }
}

