/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class Waypoint {
    private final PlayerProfile profile;
    private final String id;
    private String name;
    private Location location;

    public Waypoint(PlayerProfile profile, String id, Location l, String name) {
        Validate.notNull((Object)profile, (String)"Profile must never be null!");
        Validate.notNull((Object)id, (String)"id must never be null!");
        Validate.notNull((Object)l, (String)"Location must never be null!");
        Validate.notNull((Object)name, (String)"Name must never be null!");
        this.profile = profile;
        this.id = id;
        this.location = l;
        this.name = name;
    }

    public PlayerProfile getOwner() {
        return this.profile;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isDeathpoint() {
        return this.name.startsWith("player:death ");
    }

    public ItemStack getIcon() {
        return SlimefunPlugin.getGPSNetwork().getIcon(this.name, this.location.getWorld().getEnvironment());
    }

    public int hashCode() {
        return Objects.hash(this.profile.getUUID(), this.id, this.name, this.location);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Waypoint)) {
            return false;
        }
        Waypoint waypoint = (Waypoint)obj;
        return this.profile.getUUID().equals(waypoint.getOwner().getUUID()) && this.id.equals(waypoint.getId()) && this.location.equals((Object)waypoint.getLocation()) && this.name.equals(waypoint.getName());
    }
}

