/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TickerTask
implements Runnable {
    private static final int VISIBILITY_THRESHOLD = 225000;
    private final Set<BlockTicker> tickers = new HashSet<BlockTicker>();
    private final ConcurrentMap<Location, Location> movingQueue = new ConcurrentHashMap<Location, Location>();
    private final ConcurrentMap<Location, Boolean> deletionQueue = new ConcurrentHashMap<Location, Boolean>();
    private final ConcurrentMap<Location, Integer> buggedBlocks = new ConcurrentHashMap<Location, Integer>();
    private final ConcurrentMap<Location, Long> blockTimings = new ConcurrentHashMap<Location, Long>();
    private final ConcurrentMap<String, Integer> machineCount = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, Long> machineTimings = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, Long> chunkTimings = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, Integer> chunkItemCount = new ConcurrentHashMap<String, Integer>();
    private final Set<String> skippedChunks = new HashSet<String>();
    private boolean halted = false;
    private int skippedBlocks = 0;
    private int chunks = 0;
    private int blocks = 0;
    private long time = 0L;
    private boolean running = false;

    public void abortTick() {
        this.running = false;
    }

    @Override
    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        long timestamp = System.nanoTime();
        this.skippedBlocks = 0;
        this.chunks = 0;
        this.blocks = 0;
        this.chunkItemCount.clear();
        this.machineCount.clear();
        this.time = 0L;
        this.chunkTimings.clear();
        this.skippedChunks.clear();
        this.machineTimings.clear();
        this.blockTimings.clear();
        HashMap<Location, Integer> bugs = new HashMap<Location, Integer>(this.buggedBlocks);
        this.buggedBlocks.clear();
        HashMap<Location, Boolean> removals = new HashMap<Location, Boolean>(this.deletionQueue);
        for (Map.Entry entry : removals.entrySet()) {
            BlockStorage._integrated_removeBlockInfo((Location)entry.getKey(), (Boolean)entry.getValue());
            this.deletionQueue.remove(entry.getKey());
        }
        if (!this.halted) {
            for (String string : BlockStorage.getTickingChunks()) {
                long chunkTimestamp = System.nanoTime();
                ++this.chunks;
                for (Location l : BlockStorage.getTickingLocations(string)) {
                    if (l.getWorld().isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4)) {
                        this.tick(l, string, bugs);
                        continue;
                    }
                    this.skippedBlocks += BlockStorage.getTickingLocations(string).size();
                    this.skippedChunks.add(string);
                    --this.chunks;
                    break;
                }
                this.chunkTimings.put(string, System.nanoTime() - chunkTimestamp);
            }
        }
        for (Map.Entry entry : this.movingQueue.entrySet()) {
            BlockStorage._integrated_moveLocationInfo((Location)entry.getKey(), (Location)entry.getValue());
        }
        this.movingQueue.clear();
        Iterator<BlockTicker> iterator = this.tickers.iterator();
        while (iterator.hasNext()) {
            iterator.next().startNewTick();
            iterator.remove();
        }
        this.time = System.nanoTime() - timestamp;
        this.running = false;
    }

    private void tick(Location l, String tickedChunk, Map<Location, Integer> bugs) {
        Block b = l.getBlock();
        SlimefunItem item = BlockStorage.check(l);
        if (item != null && item.getBlockTicker() != null) {
            ++this.blocks;
            try {
                item.getBlockTicker().update();
                if (item.getBlockTicker().isSynchronized()) {
                    Slimefun.runSync(() -> {
                        try {
                            long timestamp = System.nanoTime();
                            item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                            long machinetime = NumberUtils.getLong((Long)this.machineTimings.get(item.getID()), 0L);
                            int chunk = NumberUtils.getInt((Integer)this.chunkItemCount.get(tickedChunk), 0);
                            int machine = NumberUtils.getInt((Integer)this.machineCount.get(item.getID()), 0);
                            this.machineTimings.put(item.getID(), machinetime + (System.nanoTime() - timestamp));
                            this.chunkItemCount.put(tickedChunk, chunk + 1);
                            this.machineCount.put(item.getID(), machine + 1);
                            this.blockTimings.put(l, System.nanoTime() - timestamp);
                        }
                        catch (Exception | LinkageError x) {
                            int errors = bugs.getOrDefault(l, 0);
                            this.reportErrors(l, item, x, errors);
                        }
                    });
                } else {
                    long timestamp = System.nanoTime();
                    item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                    this.machineTimings.merge(item.getID(), System.nanoTime() - timestamp, Long::sum);
                    this.chunkItemCount.merge(tickedChunk, 1, Integer::sum);
                    this.machineCount.merge(item.getID(), 1, Integer::sum);
                    this.blockTimings.put(l, System.nanoTime() - timestamp);
                }
                this.tickers.add(item.getBlockTicker());
            }
            catch (Exception x) {
                int errors = bugs.getOrDefault(l, 0);
                this.reportErrors(l, item, x, errors);
            }
        } else {
            ++this.skippedBlocks;
        }
    }

    private void reportErrors(Location l, SlimefunItem item, Throwable x, int errors) {
        if (++errors == 1) {
            new ErrorReport(x, l, item);
            this.buggedBlocks.put(l, errors);
        } else if (errors == 4) {
            Slimefun.getLogger().log(Level.SEVERE, "X: {0} Y: {1} Z: {2} ({3})", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ(), item.getID()});
            Slimefun.getLogger().log(Level.SEVERE, "has thrown 4 error messages in the last 4 Ticks, the Block has been terminated.");
            Slimefun.getLogger().log(Level.SEVERE, "Check your /plugins/Slimefun/error-reports/ folder for details.");
            Slimefun.getLogger().log(Level.SEVERE, " ");
            BlockStorage._integrated_removeBlockInfo(l, true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> l.getBlock().setType(Material.AIR));
        } else {
            this.buggedBlocks.put(l, errors);
        }
    }

    public String getTime() {
        return NumberUtils.getAsMillis(this.time);
    }

    public void info(CommandSender sender) {
        sender.sendMessage(ChatColors.color("&2== &aSlimefun Diagnostic Tool &2=="));
        sender.sendMessage(ChatColors.color("&6Halted: &e&l" + String.valueOf(this.halted).toUpperCase(Locale.ROOT)));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&6Impact: &e" + NumberUtils.getAsMillis(this.time)));
        sender.sendMessage(ChatColors.color("&6Ticked Chunks: &e" + this.chunks));
        sender.sendMessage(ChatColors.color("&6Ticked Machines: &e" + this.blocks));
        sender.sendMessage(ChatColors.color("&6Skipped Machines: &e" + this.skippedBlocks));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&6Ticking Machines:"));
        this.summarizeTimings(sender, entry -> {
            int count = (Integer)this.machineCount.get(entry.getKey());
            String timings = NumberUtils.getAsMillis((Long)entry.getValue());
            String average = NumberUtils.getAsMillis((Long)entry.getValue() / (long)count);
            return (String)entry.getKey() + " - " + count + "x (" + timings + ", " + average + " avg/machine)";
        }, this.machineCount.keySet().stream().map(key -> new AbstractMap.SimpleEntry<String, Long>((String)key, this.machineTimings.getOrDefault(key, 0L))));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&6Ticking Chunks:"));
        this.summarizeTimings(sender, entry -> {
            int count = this.chunkItemCount.getOrDefault(entry.getKey(), 0);
            String timings = NumberUtils.getAsMillis((Long)entry.getValue());
            return this.formatChunk((String)entry.getKey()) + " - " + count + "x (" + timings + ")";
        }, this.chunkTimings.entrySet().stream().filter(entry -> !this.skippedChunks.contains(entry.getKey())));
    }

    private void summarizeTimings(CommandSender sender, Function<Map.Entry<String, Long>, String> formatter, Stream<Map.Entry<String, Long>> stream) {
        List timings = stream.sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
        if (sender instanceof Player) {
            TextComponent component = new TextComponent("   Hover for more Info");
            component.setColor(ChatColor.GRAY);
            component.setItalic(Boolean.valueOf(true));
            StringBuilder builder = new StringBuilder();
            int hidden = 0;
            for (Map.Entry entry : timings) {
                if ((Long)entry.getValue() > 225000L) {
                    builder.append("\n&c").append(formatter.apply(entry));
                    continue;
                }
                ++hidden;
            }
            builder.append("\n\n&c+ &4").append(hidden).append(" Hidden");
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)ChatColors.color(builder.toString()))));
            sender.spigot().sendMessage((BaseComponent)component);
        } else {
            int hidden = 0;
            for (Map.Entry entry : timings) {
                if ((Long)entry.getValue() > 225000L) {
                    sender.sendMessage("  " + org.bukkit.ChatColor.stripColor((String)formatter.apply(entry)));
                    continue;
                }
                ++hidden;
            }
            sender.sendMessage("+ " + hidden + " Hidden");
        }
    }

    private String formatChunk(String chunk) {
        String[] components = PatternUtils.SEMICOLON.split(chunk);
        return components[0] + " [" + components[2] + ',' + components[3] + ']';
    }

    public long getTimings(Block b) {
        return this.blockTimings.getOrDefault(b.getLocation(), 0L);
    }

    public long getTimings(String item) {
        return this.machineTimings.getOrDefault(item, 0L);
    }

    public long getTimings(Chunk c) {
        String id = c.getWorld().getName() + ';' + c.getX() + ';' + c.getZ();
        return this.chunkTimings.getOrDefault(id, 0L);
    }

    public void addBlockTimings(Location l, long time) {
        this.blockTimings.put(l, time);
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void halt() {
        this.halted = true;
    }

    public String toString() {
        return "TickerTask {\n     HALTED = " + this.halted + "\n     tickers = " + this.tickers + "\n     move = " + this.movingQueue + "\n     delete = " + this.deletionQueue + "\n     chunks = " + this.chunkItemCount + "\n     machines = " + this.machineCount + "\n     machinetime = " + this.machineTimings + "\n     chunktime = " + this.chunkTimings + "\n     skipped = " + this.skippedChunks + "\n}";
    }

    public void queueMove(Location from, Location to) {
        this.movingQueue.put(from, to);
    }

    public void queueDelete(Location l, boolean destroy) {
        this.deletionQueue.put(l, destroy);
    }

    public void start(SlimefunPlugin plugin) {
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            try {
                this.run();
            }
            catch (Exception | LinkageError x) {
                plugin.getLogger().log(Level.SEVERE, x, () -> "An Exception was caught while ticking the Block Tickers Task for Slimefun v" + SlimefunPlugin.getVersion());
                this.abortTick();
            }
        }, 100L, (long)SlimefunPlugin.getCfg().getInt("URID.custom-ticker-delay"));
    }
}

