/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockUseHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemDropHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class SlimefunItemListener
implements Listener {
    public SlimefunItemListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            boolean itemUsed;
            if (SlimefunUtils.isItemSimilar(e.getItem(), SlimefunItems.DEBUG_FISH, true)) {
                return;
            }
            PlayerRightClickEvent event = new PlayerRightClickEvent(e);
            Bukkit.getPluginManager().callEvent((Event)event);
            boolean bl = itemUsed = e.getHand() == EquipmentSlot.OFF_HAND;
            if (event.useItem() != Event.Result.DENY) {
                this.rightClickItem(e, event, itemUsed);
            }
            if (!itemUsed && event.useBlock() != Event.Result.DENY && !this.rightClickBlock(e, event)) {
                return;
            }
            if (e.useInteractedBlock() != Event.Result.DENY) {
                e.setUseInteractedBlock(event.useBlock());
            }
            if (e.useItemInHand() != Event.Result.DENY) {
                e.setUseItemInHand(event.useItem());
            }
        }
    }

    private boolean rightClickItem(PlayerInteractEvent e, PlayerRightClickEvent event, boolean defaultValue) {
        Optional<SlimefunItem> optional = event.getSlimefunItem();
        if (optional.isPresent()) {
            if (Slimefun.hasUnlocked(e.getPlayer(), optional.get(), true)) {
                return optional.get().callItemHandler(ItemUseHandler.class, handler -> handler.onRightClick(event));
            }
            event.setUseItem(Event.Result.DENY);
        }
        return defaultValue;
    }

    private boolean rightClickBlock(PlayerInteractEvent e, PlayerRightClickEvent event) {
        Optional<SlimefunItem> optional = event.getSlimefunBlock();
        if (optional.isPresent()) {
            if (!Slimefun.hasUnlocked(e.getPlayer(), optional.get(), true)) {
                e.setCancelled(true);
                return false;
            }
            boolean interactable = optional.get().callItemHandler(BlockUseHandler.class, handler -> handler.onRightClick(event));
            if (!interactable) {
                String id = optional.get().getID();
                Player p = e.getPlayer();
                if (BlockMenuPreset.isInventory(id)) {
                    this.openInventory(p, id, e, event);
                    return false;
                }
            }
        }
        return true;
    }

    private void openInventory(Player p, String id, PlayerInteractEvent e, PlayerRightClickEvent event) {
        if (!p.isSneaking() || Material.AIR == event.getItem().getType()) {
            e.setCancelled(true);
            if (BlockStorage.hasUniversalInventory(id)) {
                UniversalBlockMenu menu = BlockStorage.getUniversalInventory(id);
                if (menu.canOpen(e.getClickedBlock(), p)) {
                    menu.open(new Player[]{p});
                } else {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "inventory.no-access", true);
                }
            } else if (BlockStorage.getStorage(e.getClickedBlock().getWorld()).hasInventory(e.getClickedBlock().getLocation())) {
                BlockMenu menu = BlockStorage.getInventory(e.getClickedBlock().getLocation());
                if (menu.canOpen(e.getClickedBlock(), p)) {
                    menu.open(new Player[]{p});
                } else {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "inventory.no-access", true);
                }
            }
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        for (ItemHandler handler : SlimefunItem.getPublicItemHandlers(ItemDropHandler.class)) {
            if (!((ItemDropHandler)handler).onItemDrop(e, e.getPlayer(), e.getItemDrop())) continue;
            return;
        }
    }
}

