/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.exceptions.IdConflictException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.IncompatibleItemHandlerException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.MissingDependencyException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.UnregisteredItemException;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.Placeable;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.attributes.WitherProof;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.OptionalMap;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SlimefunItem
implements Placeable {
    private ItemState state = ItemState.UNREGISTERED;
    protected String id;
    protected SlimefunAddon addon;
    protected ItemStack item;
    protected Category category;
    protected ItemStack[] recipe;
    protected RecipeType recipeType;
    protected ItemStack recipeOutput;
    protected Research research;
    protected boolean enchantable = true;
    protected boolean disenchantable = true;
    protected boolean hidden = false;
    protected boolean useableInWorkbench = false;
    private Optional<String> wikiLink = Optional.empty();
    private final OptionalMap<Class<? extends ItemHandler>, ItemHandler> itemhandlers = new OptionalMap(HashMap::new);
    private final Set<ItemSetting<?>> itemSettings = new HashSet();
    private boolean ticking = false;
    private BlockTicker blockTicker;
    private GeneratorTicker generatorTicker;

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(category, item, recipeType, recipe, null);
    }

    public SlimefunItem(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        Validate.notNull((Object)category, (String)"'category' is not allowed to be null!");
        Validate.notNull((Object)((Object)item), (String)"'item' is not allowed to be null!");
        Validate.notNull((Object)recipeType, (String)"'recipeType' is not allowed to be null!");
        this.category = category;
        this.item = item;
        this.id = item.getItemId();
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeOutput = recipeOutput;
    }

    protected SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        Validate.notNull((Object)category, (String)"'category' is not allowed to be null!");
        Validate.notNull((Object)item, (String)"'item' is not allowed to be null!");
        Validate.notNull((Object)id, (String)"'id' is not allowed to be null!");
        Validate.notNull((Object)recipeType, (String)"'recipeType' is not allowed to be null!");
        this.category = category;
        this.item = item;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
    }

    public final String getID() {
        return this.id;
    }

    public ItemState getState() {
        return this.state;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput != null ? this.recipeOutput.clone() : this.item.clone();
    }

    public Research getResearch() {
        return this.research;
    }

    public Set<ItemSetting<?>> getItemSettings() {
        return this.itemSettings;
    }

    public <T> Optional<ItemSetting<T>> getItemSetting(String key, Class<T> c) {
        for (ItemSetting<?> setting : this.itemSettings) {
            if (!setting.getKey().equals(key) || !c.isInstance(setting.getDefaultValue())) continue;
            return Optional.of(setting);
        }
        return Optional.empty();
    }

    public boolean isEnchantable() {
        return this.enchantable;
    }

    public boolean isDisenchantable() {
        return this.disenchantable;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        if (this.hidden != hidden) {
            this.hidden = hidden;
            if (this.state == ItemState.ENABLED) {
                if (hidden) {
                    this.category.remove(this);
                } else {
                    this.category.add(this);
                }
            }
        }
    }

    public boolean isDisabled() {
        if (this.state == ItemState.UNREGISTERED) {
            this.error("isDisabled() cannot be called before registering the item", new UnregisteredItemException(this));
            return false;
        }
        return this.state != ItemState.ENABLED;
    }

    public SlimefunAddon getAddon() {
        if (this.addon == null) {
            this.error("getAddon() cannot be called before registering the item", new UnregisteredItemException(this));
            return null;
        }
        return this.addon;
    }

    public BlockTicker getBlockTicker() {
        return this.blockTicker;
    }

    public GeneratorTicker getEnergyTicker() {
        return this.generatorTicker;
    }

    public void register(SlimefunAddon addon) {
        Validate.notNull((Object)addon, (String)"A SlimefunAddon cannot be null!");
        Validate.notNull((Object)addon.getJavaPlugin(), (String)"SlimefunAddon#getJavaPlugin() is not allowed to return null!");
        this.addon = addon;
        try {
            if (!addon.hasDependency("Slimefun")) {
                throw new MissingDependencyException(addon, "Slimefun");
            }
            this.preRegister();
            SlimefunItem conflicting = SlimefunItem.getByID(this.id);
            if (conflicting != null) {
                throw new IdConflictException(this, conflicting);
            }
            if (this.recipe == null || this.recipe.length < 9) {
                this.recipe = new ItemStack[]{null, null, null, null, null, null, null, null, null};
            }
            SlimefunPlugin.getRegistry().getAllSlimefunItems().add(this);
            SlimefunPlugin.getRegistry().getSlimefunItemIds().put(this.id, this);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".enabled", true);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".can-be-used-in-workbenches", this.useableInWorkbench);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".hide-in-guide", this.hidden);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-enchanting", this.enchantable);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-disenchanting", this.disenchantable);
            for (ItemSetting<?> setting : this.itemSettings) {
                setting.load(this);
            }
            if (this.ticking && !SlimefunPlugin.getCfg().getBoolean("URID.enable-tickers")) {
                this.state = ItemState.DISABLED;
                return;
            }
            if (this instanceof Radioactive) {
                SlimefunPlugin.getRegistry().getRadioactiveItems().add(this);
            }
            if (this instanceof WitherProof) {
                SlimefunPlugin.getRegistry().getWitherProofBlocks().put(this.id, (WitherProof)((Object)this));
            }
            if (this instanceof EnergyNetComponent && !SlimefunPlugin.getRegistry().getEnergyCapacities().containsKey(this.getID())) {
                ((EnergyNetComponent)((Object)this)).registerComponent(this.id);
            }
            if (SlimefunPlugin.getItemCfg().getBoolean(this.id + ".enabled")) {
                if (!SlimefunPlugin.getRegistry().getCategories().contains(this.category)) {
                    this.category.register();
                }
                this.state = ItemState.ENABLED;
                this.useableInWorkbench = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".can-be-used-in-workbenches");
                this.hidden = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".hide-in-guide");
                this.enchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-enchanting");
                this.disenchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-disenchanting");
                SlimefunPlugin.getRegistry().getEnabledSlimefunItems().add(this);
                this.loadItemHandlers();
            } else {
                this.state = this instanceof VanillaItem ? ItemState.VANILLA_FALLBACK : ItemState.DISABLED;
            }
            this.postRegister();
            if (SlimefunPlugin.getRegistry().isAutoLoadingEnabled() && this.state == ItemState.ENABLED) {
                this.info("Item was registered during runtime.");
                this.load();
            }
        }
        catch (Exception x) {
            this.error("Registering " + this.toString() + " has failed", x);
        }
    }

    private void loadItemHandlers() {
        for (ItemHandler handler : this.itemhandlers.values()) {
            Optional<IncompatibleItemHandlerException> exception = handler.validate(this);
            if (exception.isPresent()) {
                throw exception.get();
            }
            if (handler.isPrivate()) continue;
            Set<ItemHandler> handlerset = SlimefunItem.getPublicItemHandlers(handler.getIdentifier());
            handlerset.add(handler);
        }
    }

    public void setResearch(Research research) {
        if (this.research != null) {
            this.research.getAffectedItems().remove(this);
        }
        if (research != null) {
            research.getAffectedItems().add(this);
        }
        this.research = research;
    }

    public void setRecipe(ItemStack[] recipe) {
        if (recipe == null || recipe.length != 9) {
            throw new IllegalArgumentException("Recipes must be of length 9");
        }
        this.recipe = recipe;
    }

    public void setRecipeType(RecipeType type) {
        Validate.notNull((Object)type, (String)"The RecipeType is not allowed to be null!");
        this.recipeType = type;
    }

    public void setCategory(Category category) {
        Validate.notNull((Object)category, (String)"The Category is not allowed to be null!");
        this.category.remove(this);
        category.add(this);
        this.category = category;
    }

    public void setRecipeOutput(ItemStack output) {
        this.recipeOutput = output;
    }

    public boolean isUseableInWorkbench() {
        return this.useableInWorkbench;
    }

    public SlimefunItem setUseableInWorkbench(boolean useable) {
        this.useableInWorkbench = useable;
        return this;
    }

    public boolean isItem(ItemStack item) {
        Optional<String> itemId;
        if (item == null) {
            return false;
        }
        if (item instanceof SlimefunItemStack) {
            return this.getID().equals(((SlimefunItemStack)item).getItemId());
        }
        if (item.hasItemMeta() && (itemId = SlimefunPlugin.getItemDataService().getItemData(item)).isPresent()) {
            return this.getID().equals(itemId.get());
        }
        if (SlimefunPlugin.getMinecraftVersion().isBefore(MinecraftVersion.MINECRAFT_1_14) || SlimefunPlugin.getRegistry().isBackwardsCompatible()) {
            boolean loreInsensitive = this instanceof Rechargeable || this instanceof SlimefunBackpack || this.id.equals("BROKEN_SPAWNER") || this.id.equals("REINFORCED_SPAWNER");
            return SlimefunUtils.isItemSimilar(item, this.item, !loreInsensitive);
        }
        return false;
    }

    public void load() {
        try {
            if (!this.hidden) {
                this.category.add(this);
            }
            this.recipeType.register(this.recipe, this.getRecipeOutput());
        }
        catch (Exception x) {
            this.error("Failed to properly load the Item \"" + this.id + "\"", x);
        }
    }

    public final void addItemHandler(ItemHandler ... handlers) {
        Validate.notEmpty((Object[])handlers, (String)"You cannot add zero handlers...");
        Validate.noNullElements((Object[])handlers, (String)"You cannot add any 'null' ItemHandler!");
        if (this.state != ItemState.UNREGISTERED) {
            throw new UnsupportedOperationException("You cannot add an ItemHandler after the SlimefunItem was registered.");
        }
        for (ItemHandler handler : handlers) {
            this.itemhandlers.put(handler.getIdentifier(), handler);
            if (handler instanceof BlockTicker) {
                this.ticking = true;
                SlimefunPlugin.getRegistry().getTickerBlocks().add(this.getID());
                this.blockTicker = (BlockTicker)handler;
                continue;
            }
            if (!(handler instanceof GeneratorTicker)) continue;
            this.generatorTicker = (GeneratorTicker)handler;
        }
    }

    public final void addItemSetting(ItemSetting<?> ... settings) {
        Validate.notEmpty((Object[])settings, (String)"You cannot add zero settings...");
        Validate.noNullElements((Object[])settings, (String)"You cannot add any 'null' ItemSettings!");
        if (this.state != ItemState.UNREGISTERED) {
            throw new UnsupportedOperationException("You cannot add an ItemSetting after the SlimefunItem was registered.");
        }
        for (ItemSetting<?> setting : settings) {
            if (setting == null) continue;
            for (ItemSetting<?> existingSetting : this.itemSettings) {
                if (!existingSetting.getKey().equals(setting.getKey())) continue;
                throw new IllegalArgumentException("This Item has already an ItemSetting with this key: " + setting.getKey());
            }
            this.itemSettings.add(setting);
        }
    }

    public void preRegister() {
    }

    public void postRegister() {
    }

    public final void addOficialWikipage(String page) {
        Validate.notNull((Object)page, (String)"Wiki page cannot be null.");
        this.wikiLink = Optional.of("https://github.com/TheBusyBiscuit/Slimefun4/wiki/" + page);
    }

    public Optional<String> getWikipage() {
        return this.wikiLink;
    }

    public final String getItemName() {
        Optional<String> name;
        if (this.item instanceof SlimefunItemStack && (name = ((SlimefunItemStack)this.item).getImmutableMeta().getDisplayName()).isPresent()) {
            return name.get();
        }
        return ItemUtils.getItemName(this.item);
    }

    public Collection<ItemHandler> getHandlers() {
        return this.itemhandlers.values();
    }

    public <T extends ItemHandler> boolean callItemHandler(Class<T> c, Consumer<T> callable) {
        Optional<ItemHandler> handler = this.itemhandlers.get(c);
        if (handler.isPresent()) {
            try {
                callable.accept(c.cast(handler.get()));
            }
            catch (Exception | LinkageError x) {
                this.error("Could not pass \"" + c.getSimpleName() + "\" for " + this.toString(), x);
            }
            return true;
        }
        return false;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public String toString() {
        if (this.addon == null) {
            return this.getClass().getSimpleName() + " - '" + this.id + "'";
        }
        return this.getClass().getSimpleName() + " - '" + this.id + "' (" + this.addon.getName() + " v" + this.addon.getPluginVersion() + ')';
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return Arrays.asList(this.item.clone());
    }

    @Override
    public Collection<ItemStack> getDrops(Player p) {
        return this.getDrops();
    }

    public void info(String message) {
        String msg = this.toString() + ": " + message;
        this.addon.getLogger().log(Level.INFO, msg);
    }

    public void warn(String message) {
        String msg = this.toString() + ": " + message;
        this.addon.getLogger().log(Level.WARNING, msg);
    }

    public void error(String message, Throwable throwable) {
        this.addon.getLogger().log(Level.SEVERE, "Item \"{0}\" from {1} v{2} has caused an Error!", new Object[]{this.id, this.addon.getName(), this.addon.getPluginVersion()});
        if (this.addon.getBugTrackerURL() != null) {
            this.addon.getLogger().log(Level.SEVERE, "You can report it here: {0}", this.addon.getBugTrackerURL());
        }
        this.addon.getLogger().log(Level.SEVERE, message, throwable);
        if (throwable instanceof RuntimeException && SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            throw (RuntimeException)throwable;
        }
    }

    public static SlimefunItem getByID(String id) {
        return SlimefunPlugin.getRegistry().getSlimefunItemIds().get(id);
    }

    public static SlimefunItem getByItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        if (item instanceof SlimefunItemStack) {
            return SlimefunItem.getByID(((SlimefunItemStack)item).getItemId());
        }
        Optional<String> itemID = SlimefunPlugin.getItemDataService().getItemData(item);
        if (itemID.isPresent()) {
            return SlimefunItem.getByID(itemID.get());
        }
        if (SlimefunPlugin.getMinecraftVersion().isBefore(MinecraftVersion.MINECRAFT_1_14) || SlimefunPlugin.getRegistry().isBackwardsCompatible()) {
            ItemStackWrapper wrapper = new ItemStackWrapper(item);
            for (SlimefunItem sfi : SlimefunPlugin.getRegistry().getAllSlimefunItems()) {
                if (!sfi.isItem(wrapper)) continue;
                SlimefunPlugin.getItemDataService().setItemData(item, sfi.getID());
                return sfi;
            }
        }
        return null;
    }

    public static Set<ItemHandler> getPublicItemHandlers(Class<? extends ItemHandler> identifier) {
        return SlimefunPlugin.getRegistry().getPublicItemHandlers().computeIfAbsent(identifier, c -> new HashSet());
    }

    public static void registerBlockHandler(String id, SlimefunBlockHandler handler) {
        SlimefunPlugin.getRegistry().getBlockHandlers().put(id, handler);
    }
}

