/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.exceptions.PrematureCodeException;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Soulbound;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.EmeraldEnchants.EmeraldEnchants;
import me.mrCookieSlime.EmeraldEnchants.ItemEnchantment;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.ImmutableItemMeta;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class SlimefunUtils {
    private static final String EMERALDENCHANTS_LORE = ChatColor.YELLOW.toString() + ChatColor.YELLOW.toString() + ChatColor.GRAY.toString();
    private static final String NO_PICKUP_METADATA = "no_pickup";
    private static final NamespacedKey SOULBOUND_KEY = new NamespacedKey((Plugin)SlimefunPlugin.instance, "soulbound");
    private static final String SOULBOUND_LORE = ChatColor.GRAY + "Soulbound";

    private SlimefunUtils() {
    }

    public static boolean hasNoPickupFlag(Item item) {
        return item.hasMetadata(NO_PICKUP_METADATA);
    }

    public static void markAsNoPickup(Item item, String context) {
        item.setMetadata(NO_PICKUP_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)SlimefunPlugin.instance, (Object)context));
    }

    public static boolean isSoulbound(ItemStack item) {
        SlimefunItem sfItem;
        Object container;
        ItemMeta meta;
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta itemMeta = meta = item.hasItemMeta() ? item.getItemMeta() : null;
        if (meta != null && SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14) && (container = meta.getPersistentDataContainer()).has(SOULBOUND_KEY, PersistentDataType.BYTE)) {
            return true;
        }
        if (SlimefunPlugin.getThirdPartySupportService().isEmeraldEnchantsInstalled()) {
            item = item.clone();
            for (ItemEnchantment enchantment : EmeraldEnchants.getInstance().getRegistry().getEnchantments(item)) {
                EmeraldEnchants.getInstance().getRegistry().applyEnchantment(item, enchantment.getEnchantment(), 0);
            }
        }
        if ((sfItem = SlimefunItem.getByItem(item)) instanceof Soulbound) {
            return !sfItem.isDisabled();
        }
        if (meta != null) {
            return meta.hasLore() && meta.getLore().contains(SOULBOUND_LORE);
        }
        return false;
    }

    public static void setSoulbound(ItemStack item, boolean makeSoulbound) {
        List lore;
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("A soulbound item cannot be null or air!");
        }
        boolean isSoulbound = SlimefunUtils.isSoulbound(item);
        ItemMeta meta = item.getItemMeta();
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (makeSoulbound && !isSoulbound) {
                container.set(SOULBOUND_KEY, PersistentDataType.BYTE, (Object)1);
            }
            if (!makeSoulbound && isSoulbound) {
                container.remove(SOULBOUND_KEY);
            }
        }
        List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        if (makeSoulbound && !isSoulbound) {
            lore.add(SOULBOUND_LORE);
        }
        if (!makeSoulbound && isSoulbound) {
            lore.remove(SOULBOUND_LORE);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static boolean isRadioactive(ItemStack item) {
        return SlimefunItem.getByItem(item) instanceof Radioactive;
    }

    public static ItemStack getCustomHead(String texture) {
        if (SlimefunPlugin.instance == null) {
            throw new PrematureCodeException("You cannot instantiate a custom head before Slimefun was loaded.");
        }
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        String base64 = texture;
        if (PatternUtils.ALPHANUMERIC.matcher(texture).matches()) {
            base64 = Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + texture + "\"}}}").getBytes(StandardCharsets.UTF_8));
        }
        return SkullItem.fromBase64(base64);
    }

    public static boolean containsSimilarItem(Inventory inventory, ItemStack item, boolean checkLore) {
        if (inventory == null || item == null) {
            return false;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(item);
        for (ItemStack stack : inventory.getStorageContents()) {
            if (stack == null || stack.getType() == Material.AIR || !SlimefunUtils.isItemSimilar(stack, wrapper, checkLore)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemSimilar(ItemStack item, ItemStack sfitem, boolean checkLore) {
        return SlimefunUtils.isItemSimilar(item, sfitem, checkLore, true);
    }

    public static boolean isItemSimilar(ItemStack item, ItemStack sfitem, boolean checkLore, boolean checkAmount) {
        if (item == null) {
            return sfitem == null;
        }
        if (sfitem == null) {
            return false;
        }
        if (item.getType() != sfitem.getType()) {
            return false;
        }
        if (checkAmount && item.getAmount() < sfitem.getAmount()) {
            return false;
        }
        if (sfitem instanceof SlimefunItemStack && item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId().equals(((SlimefunItemStack)sfitem).getItemId());
        }
        boolean sfItemHasMeta = sfitem.hasItemMeta();
        if (item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            if (sfitem instanceof SlimefunItemStack) {
                Optional<String> id = SlimefunPlugin.getItemDataService().getItemData(itemMeta);
                if (id.isPresent()) {
                    return id.get().equals(((SlimefunItemStack)sfitem).getItemId());
                }
                ImmutableItemMeta meta = ((SlimefunItemStack)sfitem).getImmutableMeta();
                return SlimefunUtils.equalsItemMeta(itemMeta, meta, checkLore);
            }
            if (sfItemHasMeta) {
                return SlimefunUtils.equalsItemMeta(itemMeta, sfitem.getItemMeta(), checkLore);
            }
        } else {
            return !sfItemHasMeta;
        }
        return false;
    }

    private static boolean equalsItemMeta(ItemMeta itemMeta, ImmutableItemMeta meta, boolean checkLore) {
        Optional<String> displayName = meta.getDisplayName();
        if (itemMeta.hasDisplayName() && displayName.isPresent()) {
            if (itemMeta.getDisplayName().equals(displayName.get())) {
                Optional<List<String>> itemLore = meta.getLore();
                if (checkLore) {
                    if (itemMeta.hasLore() && itemLore.isPresent()) {
                        return SlimefunUtils.equalsLore(itemMeta.getLore(), itemLore.get());
                    }
                    return !itemMeta.hasLore() && !itemLore.isPresent();
                }
                return true;
            }
            return false;
        }
        if (!itemMeta.hasDisplayName() && !displayName.isPresent()) {
            Optional<List<String>> itemLore = meta.getLore();
            if (checkLore) {
                if (itemMeta.hasLore() && itemLore.isPresent()) {
                    return SlimefunUtils.equalsLore(itemMeta.getLore(), itemLore.get());
                }
                return !itemMeta.hasLore() && !itemLore.isPresent();
            }
            return true;
        }
        return false;
    }

    private static boolean equalsItemMeta(ItemMeta itemMeta, ItemMeta sfitemMeta, boolean checkLore) {
        if (itemMeta.hasDisplayName() && sfitemMeta.hasDisplayName()) {
            if (itemMeta.getDisplayName().equals(sfitemMeta.getDisplayName())) {
                if (checkLore) {
                    if (itemMeta.hasLore() && sfitemMeta.hasLore()) {
                        return SlimefunUtils.equalsLore(itemMeta.getLore(), sfitemMeta.getLore());
                    }
                    return !itemMeta.hasLore() && !sfitemMeta.hasLore();
                }
                return true;
            }
            return false;
        }
        if (!itemMeta.hasDisplayName() && !sfitemMeta.hasDisplayName()) {
            if (checkLore) {
                if (itemMeta.hasLore() && sfitemMeta.hasLore()) {
                    return SlimefunUtils.equalsLore(itemMeta.getLore(), sfitemMeta.getLore());
                }
                return !itemMeta.hasLore() && !sfitemMeta.hasLore();
            }
            return true;
        }
        return false;
    }

    private static boolean equalsLore(List<String> lore, List<String> lore2) {
        StringBuilder string1 = new StringBuilder();
        StringBuilder string2 = new StringBuilder();
        for (String string : lore) {
            if (string.equals(SOULBOUND_LORE) || string.startsWith(EMERALDENCHANTS_LORE)) continue;
            string1.append("-NEW LINE-").append(string);
        }
        for (String string : lore2) {
            if (string.equals(SOULBOUND_LORE) || string.startsWith(EMERALDENCHANTS_LORE)) continue;
            string2.append("-NEW LINE-").append(string);
        }
        return string1.toString().equals(string2.toString());
    }
}

