/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.EnumMap;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class AutoBrewer
extends AContainer {
    private static final Map<Material, PotionType> potionRecipes = new EnumMap<Material, PotionType>(Material.class);
    private static final Map<PotionType, PotionType> fermentations = new EnumMap<PotionType, PotionType>(PotionType.class);

    public AutoBrewer(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    protected void tick(Block b) {
        BlockMenu menu = BlockStorage.getInventory(b.getLocation());
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.isChargable(b)) {
                    if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    progress.put(b, timeleft - 1);
                } else {
                    progress.put(b, timeleft - 1);
                }
            } else {
                menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                for (ItemStack item : ((MachineRecipe)processing.get(b)).getOutput()) {
                    menu.pushItem(item, this.getOutputSlots());
                }
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe recipe = this.findRecipe(menu);
            if (recipe != null) {
                if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                    return;
                }
                for (int slot : this.getInputSlots()) {
                    menu.consumeItem(slot);
                }
                processing.put(b, recipe);
                progress.put(b, recipe.getTicks());
            }
        }
    }

    private MachineRecipe findRecipe(BlockMenu menu) {
        ItemStack input1 = menu.getItemInSlot(this.getInputSlots()[0]);
        ItemStack input2 = menu.getItemInSlot(this.getInputSlots()[1]);
        if (input1 == null || input2 == null) {
            return null;
        }
        if (this.isPotion(input1.getType()) || this.isPotion(input2.getType())) {
            boolean slot = this.isPotion(input1.getType());
            ItemStack potionItem = slot ? input1 : input2;
            ItemStack ingredient = slot ? input2 : input1;
            PotionMeta potion = (PotionMeta)potionItem.getItemMeta();
            if (ingredient.hasItemMeta()) {
                return null;
            }
            PotionData potionData = potion.getBasePotionData();
            ItemStack output = this.brew(ingredient.getType(), potionItem.getType(), potion, potionData);
            if (output == null) {
                return null;
            }
            output.setItemMeta((ItemMeta)potion);
            return new MachineRecipe(30, new ItemStack[]{input1, input2}, new ItemStack[]{output});
        }
        return null;
    }

    private ItemStack brew(Material input, Material potionType, PotionMeta potion, PotionData potionData) {
        if (potionData.getType() == PotionType.WATER) {
            if (input == Material.FERMENTED_SPIDER_EYE) {
                potion.setBasePotionData(new PotionData(PotionType.WEAKNESS, false, false));
                return new ItemStack(potionType);
            }
            if (input == Material.NETHER_WART) {
                potion.setBasePotionData(new PotionData(PotionType.AWKWARD, false, false));
                return new ItemStack(potionType);
            }
            if (potionType == Material.POTION && input == Material.GUNPOWDER) {
                return new ItemStack(Material.SPLASH_POTION);
            }
            if (potionType == Material.SPLASH_POTION && input == Material.DRAGON_BREATH) {
                return new ItemStack(Material.LINGERING_POTION);
            }
            return null;
        }
        if (input == Material.FERMENTED_SPIDER_EYE) {
            potion.setBasePotionData(new PotionData(fermentations.get(potionData.getType()), false, false));
            return new ItemStack(potionType);
        }
        if (input == Material.REDSTONE) {
            potion.setBasePotionData(new PotionData(potionData.getType(), true, potionData.isUpgraded()));
            return new ItemStack(potionType);
        }
        if (input == Material.GLOWSTONE_DUST) {
            potion.setBasePotionData(new PotionData(potionData.getType(), potionData.isExtended(), true));
            return new ItemStack(potionType);
        }
        if (potionData.getType() == PotionType.AWKWARD && potionRecipes.containsKey(input)) {
            potion.setBasePotionData(new PotionData(potionRecipes.get(input), false, false));
            return new ItemStack(potionType);
        }
        return null;
    }

    private boolean isPotion(Material mat) {
        return mat == Material.POTION || mat == Material.SPLASH_POTION || mat == Material.LINGERING_POTION;
    }

    @Override
    public String getInventoryTitle() {
        return "&6Auto-Brewer";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.CARROT_ON_A_STICK);
    }

    @Override
    public int getEnergyConsumption() {
        return 6;
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_BREWER";
    }

    @Override
    public int getCapacity() {
        return 128;
    }

    static {
        potionRecipes.put(Material.SUGAR, PotionType.SPEED);
        potionRecipes.put(Material.RABBIT_FOOT, PotionType.JUMP);
        potionRecipes.put(Material.BLAZE_POWDER, PotionType.STRENGTH);
        potionRecipes.put(Material.GLISTERING_MELON_SLICE, PotionType.INSTANT_HEAL);
        potionRecipes.put(Material.SPIDER_EYE, PotionType.POISON);
        potionRecipes.put(Material.GHAST_TEAR, PotionType.REGEN);
        potionRecipes.put(Material.MAGMA_CREAM, PotionType.FIRE_RESISTANCE);
        potionRecipes.put(Material.PUFFERFISH, PotionType.WATER_BREATHING);
        potionRecipes.put(Material.GOLDEN_CARROT, PotionType.NIGHT_VISION);
        potionRecipes.put(Material.TURTLE_HELMET, PotionType.TURTLE_MASTER);
        potionRecipes.put(Material.PHANTOM_MEMBRANE, PotionType.SLOW_FALLING);
        fermentations.put(PotionType.SPEED, PotionType.SLOWNESS);
        fermentations.put(PotionType.JUMP, PotionType.SLOWNESS);
        fermentations.put(PotionType.INSTANT_HEAL, PotionType.INSTANT_DAMAGE);
        fermentations.put(PotionType.POISON, PotionType.INSTANT_DAMAGE);
        fermentations.put(PotionType.NIGHT_VISION, PotionType.INVISIBILITY);
    }
}

