/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.Talisman;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.TalismanEnchantment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class MagicianTalisman
extends Talisman {
    private final Set<TalismanEnchantment> enchantments = new HashSet<TalismanEnchantment>();

    public MagicianTalisman(SlimefunItemStack item, ItemStack[] recipe) {
        super(item, recipe, false, false, "magician", 80, new PotionEffect[0]);
        for (Enchantment enchantment : Enchantment.values()) {
            try {
                for (int i = 1; i <= enchantment.getMaxLevel(); ++i) {
                    this.enchantments.add(new TalismanEnchantment(enchantment, i));
                }
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, x, () -> "The following Exception occured while trying to register the following Enchantment: " + enchantment);
            }
        }
        if (!this.enchantments.isEmpty()) {
            this.addItemSetting(this.enchantments.toArray(new ItemSetting[0]));
        }
    }

    public TalismanEnchantment getRandomEnchantment(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        List enabled = this.enchantments.stream().filter(e -> e.getEnchantment().canEnchantItem(item)).filter(ItemSetting::getValue).collect(Collectors.toList());
        return enabled.isEmpty() ? null : (TalismanEnchantment)enabled.get(ThreadLocalRandom.current().nextInt(enabled.size()));
    }
}

