/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Locale;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class Language {
    private final String id;
    private final ItemStack item;
    private FileConfiguration messages;
    private FileConfiguration researches;
    private FileConfiguration resources;
    private FileConfiguration categories;
    private FileConfiguration recipeTypes;

    public Language(String id, String hash) {
        Validate.notNull((Object)id, (String)"A Language must have an id that is not null!");
        Validate.notNull((Object)hash, (String)"A Language must have a texture that is not null!");
        this.id = id;
        this.item = SlimefunUtils.getCustomHead(hash);
        SlimefunPlugin.getItemTextureService().setTexture(this.item, "_UI_LANGUAGE_" + id.toUpperCase(Locale.ROOT));
    }

    public String getId() {
        return this.id;
    }

    FileConfiguration getMessagesFile() {
        return this.messages;
    }

    FileConfiguration getResearchesFile() {
        return this.researches;
    }

    FileConfiguration getResourcesFile() {
        return this.resources;
    }

    FileConfiguration getCategoriesFile() {
        return this.categories;
    }

    FileConfiguration getRecipeTypesFile() {
        return this.recipeTypes;
    }

    public void setMessagesFile(FileConfiguration config) {
        Validate.notNull((Object)config);
        this.messages = config;
    }

    public void setResearchesFile(FileConfiguration config) {
        Validate.notNull((Object)config);
        this.researches = config;
    }

    public void setResourcesFile(FileConfiguration config) {
        Validate.notNull((Object)config);
        this.resources = config;
    }

    public void setCategoriesFile(FileConfiguration config) {
        Validate.notNull((Object)config);
        this.categories = config;
    }

    public void setRecipeTypesFile(FileConfiguration config) {
        Validate.notNull((Object)config);
        this.recipeTypes = config;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getName(Player p) {
        String name = SlimefunPlugin.getLocal().getMessage(p, "languages." + this.id);
        return name != null ? name : this.toString();
    }

    public boolean isDefault() {
        return this == SlimefunPlugin.getLocal().getDefaultLanguage();
    }

    public String toString() {
        return "Language [ id= " + this.id + " | default=" + this.isDefault() + " ]";
    }

    public FileConfiguration[] getFiles() {
        return new FileConfiguration[]{this.getMessagesFile(), this.getCategoriesFile(), this.getResearchesFile(), this.getResourcesFile()};
    }
}

