/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class StormStaff
extends SimpleSlimefunItem<ItemUseHandler> {
    private static final NamespacedKey usageKey = new NamespacedKey((Plugin)SlimefunPlugin.instance, "stormstaff_usage");
    public static final int MAX_USES = 8;

    public StormStaff(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe, StormStaff.getCraftedOutput());
    }

    private static ItemStack getCraftedOutput() {
        ItemStack item = SlimefunItems.STAFF_STORM.clone();
        ItemMeta im = item.getItemMeta();
        List lore = im.getLore();
        lore.set(4, ChatColors.color("&e8 Uses &7left"));
        im.setLore(lore);
        item.setItemMeta(im);
        return item;
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            if (p.getFoodLevel() >= 4 || p.getGameMode() == GameMode.CREATIVE) {
                Location loc = p.getTargetBlock(null, 30).getLocation();
                if (loc.getWorld() != null && loc.getChunk().isLoaded()) {
                    if (loc.getWorld().getPVP() && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, loc, ProtectableAction.PVP)) {
                        e.cancel();
                        this.useItem(p, item, loc);
                    } else {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.no-pvp", true);
                    }
                }
            } else {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.hungry", true);
            }
        };
    }

    private void useItem(Player p, ItemStack item, Location loc) {
        ItemMeta meta;
        int usesLeft;
        loc.getWorld().strikeLightning(loc);
        if (p.getInventory().getItemInMainHand().getType() == Material.SHEARS) {
            return;
        }
        if (p.getGameMode() != GameMode.CREATIVE) {
            FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)p, p.getFoodLevel() - 4);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                p.setFoodLevel(event.getFoodLevel());
            }
        }
        if ((usesLeft = ((Integer)(meta = item.getItemMeta()).getPersistentDataContainer().getOrDefault(usageKey, PersistentDataType.INTEGER, (Object)8)).intValue()) == 1) {
            p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            item.setAmount(0);
        } else {
            meta.getPersistentDataContainer().set(usageKey, PersistentDataType.INTEGER, (Object)(--usesLeft));
            List lore = meta.getLore();
            lore.set(4, ChatColors.color("&e" + usesLeft + ' ' + (usesLeft > 1 ? "Uses" : "Use") + " &7left"));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }
}

