/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GrapplingHook;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GrapplingHookListener
implements Listener {
    private GrapplingHook grapplingHook;
    private final Map<UUID, Boolean> grappleState = new HashMap<UUID, Boolean>();
    private final Set<UUID> invulnerable = new HashSet<UUID>();
    private final Map<UUID, Entity[]> temporaryEntities = new HashMap<UUID, Entity[]>();

    public void register(SlimefunPlugin plugin, GrapplingHook grapplingHook) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.grapplingHook = grapplingHook;
    }

    @EventHandler
    public void onArrowHitEntity(EntityDamageByEntityEvent e) {
        if (this.grapplingHook == null || this.grapplingHook.isDisabled()) {
            return;
        }
        if (e.getDamager() instanceof Arrow) {
            this.handleGrapplingHook((Arrow)e.getDamager());
        }
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent e) {
        if (this.grapplingHook == null || this.grapplingHook.isDisabled()) {
            return;
        }
        Slimefun.runSync(() -> {
            if (e.getEntity().isValid() && e.getEntity() instanceof Arrow) {
                this.handleGrapplingHook((Arrow)e.getEntity());
            }
        }, 4L);
    }

    @EventHandler
    public void onArrowHit(EntityDamageEvent e) {
        if (this.grapplingHook == null || this.grapplingHook.isDisabled()) {
            return;
        }
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL && this.invulnerable.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
            this.invulnerable.remove(e.getEntity().getUniqueId());
        }
    }

    private void handleGrapplingHook(Arrow arrow) {
        if (arrow != null && arrow.getShooter() instanceof Player && this.grappleState.containsKey(((Player)arrow.getShooter()).getUniqueId())) {
            Player p = (Player)arrow.getShooter();
            if (p.getGameMode() != GameMode.CREATIVE && this.grappleState.get(p.getUniqueId()).booleanValue()) {
                arrow.getWorld().dropItem(arrow.getLocation(), (ItemStack)SlimefunItems.GRAPPLING_HOOK);
            }
            Vector velocity = new Vector(0.0, 0.2, 0.0);
            if (p.getLocation().distance(arrow.getLocation()) < 3.0) {
                if (arrow.getLocation().getY() <= p.getLocation().getY()) {
                    velocity = arrow.getLocation().toVector().subtract(p.getLocation().toVector());
                }
            } else {
                double d;
                Location l = p.getLocation();
                l.setY(l.getY() + 0.5);
                p.teleport(l);
                double g = -0.08;
                double t = d = arrow.getLocation().distance(l);
                double vX = (1.0 + 0.08 * t) * (arrow.getLocation().getX() - l.getX()) / t;
                double vY = (1.0 + 0.04 * t) * (arrow.getLocation().getY() - l.getY()) / t - 0.5 * g * t;
                double vZ = (1.0 + 0.08 * t) * (arrow.getLocation().getZ() - l.getZ()) / t;
                velocity = p.getVelocity();
                velocity.setX(vX);
                velocity.setY(vY);
                velocity.setZ(vZ);
            }
            p.setVelocity(velocity);
            for (Entity n : this.temporaryEntities.get(p.getUniqueId())) {
                if (!n.isValid()) continue;
                n.remove();
            }
            Slimefun.runSync(() -> {
                this.grappleState.remove(p.getUniqueId());
                this.temporaryEntities.remove(p.getUniqueId());
            }, 20L);
        }
    }

    public boolean isGrappling(UUID uuid) {
        return this.grappleState.containsKey(uuid);
    }

    public void addGrapplingHook(UUID uuid, Arrow arrow, Bat b, boolean state, long despawnTicks) {
        this.grappleState.put(uuid, state);
        this.invulnerable.add(uuid);
        this.temporaryEntities.put(uuid, new Entity[]{b, arrow});
        Slimefun.runSync(() -> {
            if (this.grappleState.containsKey(uuid)) {
                SlimefunPlugin.getBowListener().getBows().remove(uuid);
                for (Entity n : this.temporaryEntities.get(uuid)) {
                    if (!n.isValid()) continue;
                    n.remove();
                }
                Slimefun.runSync(() -> {
                    this.invulnerable.remove(uuid);
                    this.grappleState.remove(uuid);
                    this.temporaryEntities.remove(uuid);
                }, 20L);
            }
        }, despawnTicks);
    }
}

