/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.MagicianTalisman;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.Talisman;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.TalismanEnchantment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TalismanListener
implements Listener {
    private final int[] armorSlots = new int[]{39, 38, 37, 36};

    public TalismanListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamageGet(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            if (e.getCause() == EntityDamageEvent.DamageCause.LAVA) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_LAVA);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WATER);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_ANGEL);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.FIRE) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_FIRE);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_KNIGHT);
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WARRIOR);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.PROJECTILE && ((EntityDamageByEntityEvent)e).getDamager() instanceof Projectile) {
                Projectile projectile = (Projectile)((EntityDamageByEntityEvent)e).getDamager();
                if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WHIRLWIND)) {
                    Player p = (Player)e.getEntity();
                    Vector direction = p.getEyeLocation().getDirection().multiply(2.0);
                    Location loc = p.getEyeLocation().add(direction.getX(), direction.getY(), direction.getZ());
                    Projectile clone = (Projectile)e.getEntity().getWorld().spawnEntity(loc, projectile.getType());
                    clone.setShooter(projectile.getShooter());
                    clone.setVelocity(direction);
                    projectile.remove();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onKill(EntityDeathEvent e) {
        if (e.getDrops().isEmpty() || e.getEntity().getKiller() == null) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (!(entity instanceof Player) && !(entity instanceof ArmorStand) && Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_HUNTER)) {
            Collection<ItemStack> extraDrops = this.getExtraDrops(e.getEntity(), e.getDrops());
            for (ItemStack drop : extraDrops) {
                if (drop == null) continue;
                e.getDrops().add(drop.clone());
            }
        }
    }

    private Collection<ItemStack> getExtraDrops(LivingEntity entity, Collection<ItemStack> drops) {
        EntityEquipment equipment;
        ChestedHorse horse;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(drops);
        if (entity instanceof ChestedHorse && (horse = (ChestedHorse)entity).isCarryingChest()) {
            items.remove(new ItemStack(Material.CHEST));
            for (ItemStack item : horse.getInventory().getStorageContents()) {
                items.remove(item);
            }
        }
        if ((equipment = entity.getEquipment()) != null) {
            for (ItemStack item : equipment.getArmorContents()) {
                items.remove(item);
            }
            items.remove(equipment.getItemInMainHand());
            items.remove(equipment.getItemInOffHand());
        }
        return items;
    }

    @EventHandler
    public void onItemBreak(PlayerItemBreakEvent e) {
        if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_ANVIL)) {
            ItemStack item;
            ItemMeta meta;
            PlayerInventory inv = e.getPlayer().getInventory();
            int slot = inv.getHeldItemSlot();
            if (!inv.getItem(inv.getHeldItemSlot()).equals((Object)e.getBrokenItem())) {
                for (int s : this.armorSlots) {
                    if (!e.getBrokenItem().equals((Object)inv.getItem(s))) continue;
                    slot = s;
                    break;
                }
            }
            if ((meta = (item = e.getBrokenItem().clone()).getItemMeta()) instanceof Damageable) {
                ((Damageable)meta).setDamage(0);
            }
            item.setItemMeta(meta);
            int itemSlot = slot;
            Slimefun.runSync(() -> inv.setItem(itemSlot, item), 1L);
        }
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent e) {
        if (e.isSprinting()) {
            Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_TRAVELLER);
        }
    }

    @EventHandler
    public void onEnchant(EnchantItemEvent e) {
        MagicianTalisman talisman;
        TalismanEnchantment enchantment;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_MAGICIAN) && (enchantment = (talisman = (MagicianTalisman)SlimefunItems.TALISMAN_MAGICIAN.getItem()).getRandomEnchantment(e.getItem())) != null) {
            e.getEnchantsToAdd().put(enchantment.getEnchantment(), enchantment.getLevel());
        }
        if (!e.getEnchantsToAdd().containsKey(Enchantment.SILK_TOUCH) && Enchantment.LOOT_BONUS_BLOCKS.canEnchantItem(e.getItem()) && Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WIZARD)) {
            Set enchantments = e.getEnchantsToAdd().keySet();
            for (Enchantment enchantment2 : enchantments) {
                if (((Random)random).nextInt(100) >= 40) continue;
                e.getEnchantsToAdd().put(enchantment2, ((Random)random).nextInt(3) + 1);
            }
            e.getEnchantsToAdd().put(Enchantment.LOOT_BONUS_BLOCKS, ((Random)random).nextInt(3) + 3);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        if (item.getType() != Material.AIR && item.getAmount() > 0) {
            ArrayList drops = new ArrayList(e.getBlock().getDrops(item));
            int dropAmount = 1;
            if (item.getEnchantments().containsKey(Enchantment.LOOT_BONUS_BLOCKS) && !item.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                dropAmount = ((Random)random).nextInt(item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS) + 2) - 1;
                dropAmount = Math.max(dropAmount, 1);
                dropAmount = (e.getBlock().getType() == Material.LAPIS_ORE ? 4 + ((Random)random).nextInt(5) : 1) * (dropAmount + 1);
            }
            if (!item.getEnchantments().containsKey(Enchantment.SILK_TOUCH) && MaterialCollections.getAllOres().contains(e.getBlock().getType()) && Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_MINER)) {
                for (ItemStack drop : drops) {
                    if (drop.getType().isBlock()) continue;
                    int amount = Math.max(1, dropAmount * 2 - drop.getAmount());
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), (ItemStack)new CustomItem(drop, amount));
                }
            }
        }
    }
}

