/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GoldPan;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public abstract class ElectricGoldPan
extends AContainer
implements RecipeDisplayItem {
    private final GoldPan goldPan = (GoldPan)SlimefunItems.GOLD_PAN.getItem();
    private final GoldPan netherGoldPan = (GoldPan)SlimefunItems.NETHER_GOLD_PAN.getItem();

    public ElectricGoldPan(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> recipes = new ArrayList<ItemStack>();
        recipes.addAll(this.goldPan.getDisplayRecipes());
        recipes.addAll(this.netherGoldPan.getDisplayRecipes());
        return recipes;
    }

    @Override
    public String getInventoryTitle() {
        return "&6Electric Gold Pan";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_SHOVEL);
    }

    @Override
    public abstract int getSpeed();

    @Override
    protected void tick(Block b) {
        block7: {
            BlockMenu menu;
            block5: {
                block6: {
                    menu = BlockStorage.getInventory(b);
                    if (!this.isProcessing(b)) break block5;
                    int timeleft = (Integer)progress.get(b);
                    if (timeleft <= 0 || this.getSpeed() >= 10) break block6;
                    ChestMenuUtils.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                    if (ChargableBlock.isChargable(b)) {
                        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                            return;
                        }
                        ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                        progress.put(b, timeleft - 1);
                    } else {
                        progress.put(b, timeleft - 1);
                    }
                    break block7;
                }
                if (!ChargableBlock.isChargable(b)) break block7;
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                menu.pushItem(((MachineRecipe)processing.get(b)).getOutput()[0].clone(), this.getOutputSlots());
                progress.remove(b);
                processing.remove(b);
                break block7;
            }
            for (int slot : this.getInputSlots()) {
                if (this.hasFreeSlot(menu) && this.process(b, menu, slot)) break;
            }
        }
    }

    private boolean hasFreeSlot(BlockMenu menu) {
        for (int slot : this.getOutputSlots()) {
            if (menu.getItemInSlot(slot) != null) continue;
            return true;
        }
        return false;
    }

    private boolean process(Block b, BlockMenu menu, int slot) {
        if (SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), new ItemStack(Material.GRAVEL), true)) {
            ItemStack output = this.goldPan.getRandomOutput();
            MachineRecipe r = new MachineRecipe(3 / this.getSpeed(), new ItemStack[0], new ItemStack[]{output});
            if (menu.fits(output, this.getOutputSlots())) {
                menu.consumeItem(slot);
                processing.put(b, r);
                progress.put(b, r.getTicks());
            }
            return true;
        }
        if (SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), new ItemStack(Material.SOUL_SAND), true)) {
            ItemStack output = this.netherGoldPan.getRandomOutput();
            MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{output});
            if (menu.fits(output, this.getOutputSlots())) {
                menu.consumeItem(slot);
                processing.put(b, r);
                progress.put(b, r.getTicks());
            }
            return true;
        }
        return false;
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_GOLD_PAN";
    }
}

