/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidAction;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.function.Predicate;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.inventory.ItemStack;

enum Instruction {
    START(AndroidType.NONE, "4ae29422db4047efdb9bac2cdae5a0719eb772fccc88a66d912320b343c341"),
    REPEAT(AndroidType.NONE, "bc8def67a12622ead1decd3d89364257b531896d87e469813131ca235b5c7"),
    WAIT(AndroidType.NONE, "2ee174f41e594e64ea3141c07daf7acf1fa045c230b2b0b0fb3da163db22f455"),
    GO_FORWARD(AndroidType.NON_FIGHTER, "d9bf6db4aeda9d8822b9f736538e8c18b9a4844f84eb45504adfbfee87eb", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.move(b, face, target);
    }),
    GO_UP(AndroidType.NON_FIGHTER, "105a2cab8b68ea57e3af992a36e47c8ff9aa87cc8776281966f8c3cf31a38", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.UP);
        android.move(b, face, target);
    }),
    GO_DOWN(AndroidType.NON_FIGHTER, "c01586e39f6ffa63b4fb301b65ca7da8a92f7353aaab89d3886579125dfbaf9", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.DOWN);
        android.move(b, face, target);
    }),
    TURN_LEFT(AndroidType.NONE, "a185c97dbb8353de652698d24b64327b793a3f32a98be67b719fbedab35e", (android, b, inv, face) -> {
        int mod = -1;
        android.rotate(b, mod);
    }),
    TURN_RIGHT(AndroidType.NONE, "31c0ededd7115fc1b23d51ce966358b27195daf26ebb6e45a66c34c69c34091", (android, b, inv, face) -> {
        int mod = 1;
        android.rotate(b, mod);
    }),
    DIG_UP(AndroidType.MINER, "2e6ce011ac9a7a75b2fcd408ad21a3ac1722f6e2eed8781cafd12552282b88", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.UP);
        android.dig(b, inv, target);
    }),
    DIG_FORWARD(AndroidType.MINER, "b6ea2135838461534372f2da6c862d21cd5f3d2c7119f2bb674bbd42791", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.dig(b, inv, target);
    }),
    DIG_DOWN(AndroidType.MINER, "8d862024108c785bc0ef7199ec77c402dbbfcc624e9f41f83d8aed8b39fd13", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.DOWN);
        android.dig(b, inv, target);
    }),
    MOVE_AND_DIG_UP(AndroidType.MINER, "2e6ce011ac9a7a75b2fcd408ad21a3ac1722f6e2eed8781cafd12552282b88", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.UP);
        android.moveAndDig(b, inv, face, target);
    }),
    MOVE_AND_DIG_FORWARD(AndroidType.MINER, "b6ea2135838461534372f2da6c862d21cd5f3d2c7119f2bb674bbd42791", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.moveAndDig(b, inv, face, target);
    }),
    MOVE_AND_DIG_DOWN(AndroidType.MINER, "8d862024108c785bc0ef7199ec77c402dbbfcc624e9f41f83d8aed8b39fd13", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.DOWN);
        android.moveAndDig(b, inv, face, target);
    }),
    ATTACK_MOBS_ANIMALS(AndroidType.FIGHTER, "c7e6c40f68b775f2efcd7bd9916b327869dcf27e24c855d0a18e07ac04fe1", (android, b, inv, face) -> {
        Predicate<LivingEntity> predicate = e -> true;
        android.attack(b, predicate);
    }),
    ATTACK_MOBS(AndroidType.FIGHTER, "c7e6c40f68b775f2efcd7bd9916b327869dcf27e24c855d0a18e07ac04fe1", (android, b, inv, face) -> {
        Predicate<LivingEntity> predicate = e -> e instanceof Monster;
        android.attack(b, predicate);
    }),
    ATTACK_ANIMALS(AndroidType.FIGHTER, "c7e6c40f68b775f2efcd7bd9916b327869dcf27e24c855d0a18e07ac04fe1", (android, b, inv, face) -> {
        Predicate<LivingEntity> predicate = e -> e instanceof Animals;
        android.attack(b, predicate);
    }),
    ATTACK_ANIMALS_ADULT(AndroidType.FIGHTER, "c7e6c40f68b775f2efcd7bd9916b327869dcf27e24c855d0a18e07ac04fe1", (android, b, inv, face) -> {
        Predicate<LivingEntity> predicate = e -> e instanceof Animals && e instanceof Ageable && ((Ageable)e).isAdult();
        android.attack(b, predicate);
    }),
    CHOP_TREE(AndroidType.WOODCUTTER, "64ba49384dba7b7acdb4f70e9361e6d57cbbcbf720cf4f16c2bb83e4557"),
    CATCH_FISH(AndroidType.FISHERMAN, "fd4fde511f4454101e4a2a72bc86f12985dfcda76b64bb24dc63a9fa9e3a3", (android, b, inv, face) -> android.fish(b, inv)),
    FARM_FORWARD(AndroidType.FARMER, "4de9a522c3d9e7d85f3d82c375dc37fecc856dbd801eb3bcedc1165198bf", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.farm(inv, target);
    }),
    FARM_DOWN(AndroidType.FARMER, "2d4296b333d25319af3f33051797f9e6d821cd19a014fb7137beb86a4e9e96", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.DOWN);
        android.farm(inv, target);
    }),
    FARM_EXOTIC_FORWARD(AndroidType.ADVANCED_FARMER, "4de9a522c3d9e7d85f3d82c375dc37fecc856dbd801eb3bcedc1165198bf", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.exoticFarm(inv, target);
    }),
    FARM_EXOTIC_DOWN(AndroidType.ADVANCED_FARMER, "2d4296b333d25319af3f33051797f9e6d821cd19a014fb7137beb86a4e9e96", (android, b, inv, face) -> {
        Block target = b.getRelative(BlockFace.DOWN);
        android.exoticFarm(inv, target);
    }),
    INTERFACE_ITEMS(AndroidType.NONE, "90a4dbf6625c42be57a8ba2c330954a76bdf22785540e87a5c9672685238ec", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.depositItems(inv, target);
    }),
    INTERFACE_FUEL(AndroidType.NONE, "2432f5282a50745b912be14deda581bd4a09b977a3c32d7e9578491fee8fa7", (android, b, inv, face) -> {
        Block target = b.getRelative(face);
        android.refuel(inv, target);
    });

    private final ItemStack item;
    private final AndroidType type;
    private final AndroidAction method;

    private Instruction(AndroidType type, String texture, AndroidAction method) {
        this.type = type;
        this.item = SlimefunUtils.getCustomHead(texture);
        this.method = method;
    }

    private Instruction(AndroidType type, String texture) {
        this(type, texture, null);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public AndroidType getRequiredType() {
        return this.type;
    }

    public void execute(ProgrammableAndroid android, Block b, BlockMenu inventory, BlockFace face) {
        Validate.notNull((Object)this.method, (String)("Instruction '" + this.name() + "' must be executed manually!"));
        this.method.perform(android, b, inventory, face);
    }
}

