/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AutoAnvil
extends AContainer {
    public AutoAnvil(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public String getInventoryTitle() {
        return "Auto-Anvil";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.IRON_PICKAXE);
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_ANVIL";
    }

    public abstract int getRepairFactor();

    @Override
    protected void tick(Block b) {
        BlockMenu menu = BlockStorage.getInventory(b);
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.isChargable(b)) {
                    if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    progress.put(b, timeleft - 1);
                } else {
                    progress.put(b, timeleft - 1);
                }
            } else {
                menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                menu.pushItem(((MachineRecipe)processing.get(b)).getOutput()[0].clone(), this.getOutputSlots());
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe recipe = null;
            for (int slot : this.getInputSlots()) {
                ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
                ItemStack item = menu.getItemInSlot(slot);
                if (item == null || item.getType().getMaxDurability() <= 0 || ((Damageable)item.getItemMeta()).getDamage() <= 0) continue;
                if (!SlimefunUtils.isItemSimilar(target, SlimefunItems.DUCT_TAPE, true)) break;
                ItemStack repaired = this.repair(item);
                recipe = new MachineRecipe(30, new ItemStack[]{target, item}, new ItemStack[]{repaired});
                break;
            }
            if (recipe != null) {
                if (!menu.fits(recipe.getOutput()[0], this.getOutputSlots())) {
                    return;
                }
                for (int slot : this.getInputSlots()) {
                    menu.consumeItem(slot);
                }
                processing.put(b, recipe);
                progress.put(b, recipe.getTicks());
            }
        }
    }

    private ItemStack repair(ItemStack item) {
        ItemStack repaired = item.clone();
        ItemMeta meta = repaired.getItemMeta();
        short maxDurability = item.getType().getMaxDurability();
        short durability = (short)(((Damageable)meta).getDamage() - maxDurability / this.getRepairFactor());
        if (durability < 0) {
            durability = 0;
        }
        ((Damageable)meta).setDamage((int)durability);
        repaired.setItemMeta(meta);
        return repaired;
    }
}

