/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemRequest;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

abstract class ChestTerminalNetwork
extends Network {
    private static final int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private static final int[] TERMINAL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
    private static final int TERMINAL_OUT_SLOT = 17;
    private final ItemStack terminalPlaceholderItem = new CustomItem(Material.BARRIER, "&4No Item cached", new String[0]);
    protected final Set<Location> terminals = new HashSet<Location>();
    protected final Set<Location> imports = new HashSet<Location>();
    protected final Set<Location> exports = new HashSet<Location>();
    private final Set<ItemRequest> itemRequests = new HashSet<ItemRequest>();

    protected ChestTerminalNetwork(Location regulator) {
        super(SlimefunPlugin.getNetworkManager(), regulator);
    }

    protected static Optional<Block> getAttachedBlock(Block block) {
        if (block.getType() == Material.PLAYER_WALL_HEAD) {
            BlockFace face = ((Directional)block.getBlockData()).getFacing().getOppositeFace();
            return Optional.of(block.getRelative(face));
        }
        return Optional.empty();
    }

    protected void handleItemRequests(Set<Location> providers, Set<Location> destinations) {
        this.collectImportRequests();
        this.collectExportRequests();
        this.collectTerminalRequests();
        Iterator<ItemRequest> iterator = this.itemRequests.iterator();
        while (iterator.hasNext()) {
            ItemRequest request = iterator.next();
            if (!this.terminals.contains(request.getTerminal()) && !this.imports.contains(request.getTerminal()) && !this.exports.contains(request.getTerminal())) continue;
            BlockMenu menu = BlockStorage.getInventory(request.getTerminal());
            switch (request.getDirection()) {
                case INSERT: {
                    ItemStack requestedItem = request.getItem();
                    for (Location l : destinations) {
                        Optional<Block> target = ChestTerminalNetwork.getAttachedBlock(l.getBlock());
                        if (!target.isPresent() || (requestedItem = CargoUtils.insert(l.getBlock(), target.get(), requestedItem)) != null) continue;
                        menu.replaceExistingItem(request.getSlot(), null);
                        break;
                    }
                    if (requestedItem != null) {
                        menu.replaceExistingItem(request.getSlot(), requestedItem);
                    }
                    iterator.remove();
                    break;
                }
                case WITHDRAW: {
                    int slot = request.getSlot();
                    ItemStack prevStack = menu.getItemInSlot(slot);
                    if (!(prevStack == null || prevStack.getAmount() + request.getItem().getAmount() <= prevStack.getMaxStackSize() && SlimefunUtils.isItemSimilar(prevStack, new CustomItem(request.getItem(), 1), true))) {
                        iterator.remove();
                        break;
                    }
                    Object stack = null;
                    ItemStack requested = request.getItem();
                    for (Location l : providers) {
                        ItemStack is;
                        Optional<Block> target = ChestTerminalNetwork.getAttachedBlock(l.getBlock());
                        if (!target.isPresent() || (is = CargoUtils.withdraw(l.getBlock(), target.get(), requested)) == null) continue;
                        stack = stack == null ? is : new CustomItem((ItemStack)stack, stack.getAmount() + is.getAmount());
                        if (is.getAmount() == requested.getAmount()) break;
                        requested = new CustomItem(requested, requested.getAmount() - is.getAmount());
                    }
                    if (stack != null) {
                        ItemStack prev = menu.getItemInSlot(slot);
                        if (prev == null) {
                            menu.replaceExistingItem(slot, (ItemStack)stack);
                        } else {
                            menu.replaceExistingItem(slot, new CustomItem((ItemStack)stack, stack.getAmount() + prev.getAmount()));
                        }
                    }
                    iterator.remove();
                    break;
                }
            }
        }
    }

    private void collectImportRequests() {
        for (Location bus : this.imports) {
            ItemStackAndInteger stack;
            Optional<Block> target;
            BlockMenu menu = BlockStorage.getInventory(bus);
            if (menu.getItemInSlot(17) == null && (target = ChestTerminalNetwork.getAttachedBlock(bus.getBlock())).isPresent() && (stack = CargoUtils.withdraw(bus.getBlock(), target.get())) != null) {
                menu.replaceExistingItem(17, stack.getItem());
            }
            if (menu.getItemInSlot(17) == null) continue;
            this.itemRequests.add(new ItemRequest(bus, 17, menu.getItemInSlot(17), ItemTransportFlow.INSERT));
        }
    }

    private void collectExportRequests() {
        for (Location bus : this.exports) {
            Optional<Block> target;
            BlockMenu menu = BlockStorage.getInventory(bus);
            if (menu.getItemInSlot(17) != null && (target = ChestTerminalNetwork.getAttachedBlock(bus.getBlock())).isPresent()) {
                menu.replaceExistingItem(17, CargoUtils.insert(bus.getBlock(), target.get(), menu.getItemInSlot(17)));
            }
            if (menu.getItemInSlot(17) != null) continue;
            ArrayList<CustomItem> items = new ArrayList<CustomItem>();
            for (int slot : slots) {
                ItemStack template = menu.getItemInSlot(slot);
                if (template == null) continue;
                items.add(new CustomItem(template, 1));
            }
            if (items.isEmpty()) continue;
            int index = Integer.parseInt(BlockStorage.getLocationInfo(bus, "index"));
            if (++index > items.size() - 1) {
                index = 0;
            }
            BlockStorage.addBlockInfo(bus, "index", String.valueOf(index));
            this.itemRequests.add(new ItemRequest(bus, 17, (ItemStack)items.get(index), ItemTransportFlow.WITHDRAW));
        }
    }

    private void collectTerminalRequests() {
        for (Location terminal : this.terminals) {
            BlockMenu menu = BlockStorage.getInventory(terminal);
            ItemStack sendingItem = menu.getItemInSlot(17);
            if (sendingItem == null) continue;
            this.itemRequests.add(new ItemRequest(terminal, 17, sendingItem, ItemTransportFlow.INSERT));
        }
    }

    protected void updateTerminals(Set<Location> providers) {
        ArrayList<ItemStackAndInteger> items = new ArrayList<ItemStackAndInteger>();
        for (Location l : providers) {
            BlockState state;
            int slot2;
            Optional<Block> block = ChestTerminalNetwork.getAttachedBlock(l.getBlock());
            if (!block.isPresent()) continue;
            Block target = block.get();
            UniversalBlockMenu menu = BlockStorage.getUniversalInventory(target);
            if (menu != null) {
                for (int slot2 : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                    ItemStack is2 = menu.getItemInSlot(slot2);
                    this.filter(is2, items, l);
                }
                continue;
            }
            if (BlockStorage.hasInventory(target)) {
                BlockMenu blockMenu = BlockStorage.getInventory(target);
                Config cfg = BlockStorage.getLocationInfo(target.getLocation());
                if (cfg.getString("id").startsWith("BARREL_") && cfg.getString("storedItems") != null) {
                    this.gatherItemsFromBarrel(l, cfg, blockMenu, items);
                    continue;
                }
                this.handleWithdraw(blockMenu, items, l);
                continue;
            }
            if (!CargoUtils.hasInventory(target) || !((state = target.getState()) instanceof InventoryHolder)) continue;
            Inventory inv = ((InventoryHolder)state).getInventory();
            ItemStack[] itemStackArray = inv.getContents();
            slot2 = itemStackArray.length;
            for (int is2 = 0; is2 < slot2; ++is2) {
                ItemStack is3 = itemStackArray[is2];
                this.filter(is3, items, l);
            }
        }
        Collections.sort(items, Comparator.comparingInt(item -> -item.getInt()));
        for (Location l : this.terminals) {
            BlockMenu menu = BlockStorage.getInventory(l);
            int page = Integer.parseInt(BlockStorage.getLocationInfo(l, "page"));
            if (!items.isEmpty() && items.size() < (page - 1) * TERMINAL_SLOTS.length + 1) {
                page = 1;
                BlockStorage.addBlockInfo(l, "page", String.valueOf(1));
            }
            for (int i = 0; i < TERMINAL_SLOTS.length; ++i) {
                int slot = TERMINAL_SLOTS[i];
                if (items.size() > i + TERMINAL_SLOTS.length * (page - 1)) {
                    ItemStackAndInteger item2 = (ItemStackAndInteger)items.get(i + TERMINAL_SLOTS.length * (page - 1));
                    ItemStack stack = item2.getItem().clone();
                    ItemMeta im = stack.getItemMeta();
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add("");
                    lore.add(ChatColors.color("&7Stored Items: &r" + DoubleHandler.getFancyDouble(item2.getInt())));
                    if (stack.getMaxStackSize() > 1) {
                        lore.add(ChatColors.color("&7<Left Click: Request 1 | Right Click: Request " + (item2.getInt() > stack.getMaxStackSize() ? stack.getMaxStackSize() : item2.getInt()) + ">"));
                    } else {
                        lore.add(ChatColors.color("&7<Left Click: Request 1>"));
                    }
                    lore.add("");
                    if (im.hasLore()) {
                        lore.addAll(im.getLore());
                    }
                    im.setLore(lore);
                    stack.setItemMeta(im);
                    menu.replaceExistingItem(slot, stack);
                    menu.addMenuClickHandler(slot, (p, sl, is, action) -> {
                        int amount = item2.getInt() > item2.getItem().getMaxStackSize() ? item2.getItem().getMaxStackSize() : item2.getInt();
                        this.itemRequests.add(new ItemRequest(l, 44, new CustomItem(item2.getItem(), action.isRightClicked() ? amount : 1), ItemTransportFlow.WITHDRAW));
                        return false;
                    });
                    continue;
                }
                menu.replaceExistingItem(slot, this.terminalPlaceholderItem);
                menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    private void gatherItemsFromBarrel(Location l, Config cfg, BlockMenu blockMenu, List<ItemStackAndInteger> items) {
        int stored = Integer.parseInt(cfg.getString("storedItems"));
        for (int slot : blockMenu.getPreset().getSlotsAccessedByItemTransport(blockMenu, ItemTransportFlow.WITHDRAW, null)) {
            ItemStack is = blockMenu.getItemInSlot(slot);
            if (is == null || !CargoUtils.matchesFilter(l.getBlock(), is)) continue;
            boolean add = true;
            for (ItemStackAndInteger item : items) {
                if (!SlimefunUtils.isItemSimilar(is, item.getItem(), true)) continue;
                add = false;
                item.add(is.getAmount() + stored);
            }
            if (!add) continue;
            items.add(new ItemStackAndInteger(new CustomItem(is, 1), is.getAmount() + stored));
        }
    }

    private void handleWithdraw(DirtyChestMenu menu, List<ItemStackAndInteger> items, Location l) {
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
            this.filter(menu.getItemInSlot(slot), items, l);
        }
    }

    private void filter(ItemStack is, List<ItemStackAndInteger> items, Location l) {
        if (is != null && CargoUtils.matchesFilter(l.getBlock(), is)) {
            boolean add = true;
            for (ItemStackAndInteger item : items) {
                if (!SlimefunUtils.isItemSimilar(is, item.getItem(), true)) continue;
                add = false;
                item.add(is.getAmount());
            }
            if (add) {
                items.add(new ItemStackAndInteger(new CustomItem(is, 1), is.getAmount()));
            }
        }
    }
}

