/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ScriptAction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class ProgrammableAndroid
extends SlimefunItem
implements InventoryBlock,
RecipeDisplayItem {
    private static final List<BlockFace> POSSIBLE_ROTATIONS = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    private static final int[] BORDER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 18, 24, 25, 26, 27, 33, 35, 36, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] OUTPUT_BORDER = new int[]{10, 11, 12, 13, 14, 19, 23, 28, 32, 37, 38, 39, 40, 41};
    protected final Set<MachineFuel> fuelTypes = new HashSet<MachineFuel>();
    protected final String texture;

    public ProgrammableAndroid(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.texture = item.getSkullTexture().orElse(null);
        this.registerDefaultFuelTypes();
        new BlockMenuPreset(this.getID(), "Programmable Android"){

            @Override
            public void init() {
                ProgrammableAndroid.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                boolean open;
                boolean bl = open = BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(p.getUniqueId().toString()) || p.hasPermission("slimefun.android.bypass");
                if (!open) {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "inventory.no-access", true);
                }
                return open;
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                menu.replaceExistingItem(15, new CustomItem(SlimefunUtils.getCustomHead("e01c7b5726178974b3b3a01b42a590e54366026fd43808f2a787648843a7f5a"), "&aStart/Continue", new String[0]));
                menu.addMenuClickHandler(15, (p, slot, item, action) -> {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.started", true);
                    BlockStorage.addBlockInfo(b, "paused", "false");
                    p.closeInventory();
                    return false;
                });
                menu.replaceExistingItem(17, new CustomItem(SlimefunUtils.getCustomHead("16139fd1c5654e56e9e4e2c8be7eb2bd5b499d633616663feee99b74352ad64"), "&4Pause", new String[0]));
                menu.addMenuClickHandler(17, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, "paused", "true");
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.stopped", true);
                    return false;
                });
                menu.replaceExistingItem(16, new CustomItem(SlimefunUtils.getCustomHead("d78f2b7e5e75639ea7fb796c35d364c4df28b4243e66b76277aadcd6261337"), "&bMemory Core", "", "&8\u21e8 &7Click to open the Script Editor"));
                menu.addMenuClickHandler(16, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, "paused", "true");
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.stopped", true);
                    ProgrammableAndroid.this.openScriptEditor(p, b);
                    return false;
                });
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
        ProgrammableAndroid.registerBlockHandler(this.getID(), new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "owner", p.getUniqueId().toString());
                BlockStorage.addBlockInfo(b, "script", "START-TURN_LEFT-REPEAT");
                BlockStorage.addBlockInfo(b, "index", "0");
                BlockStorage.addBlockInfo(b, "fuel", "0");
                BlockStorage.addBlockInfo(b, "rotation", p.getFacing().getOppositeFace().toString());
                BlockStorage.addBlockInfo(b, "paused", "true");
                b.setType(Material.PLAYER_HEAD);
                Rotatable blockData = (Rotatable)b.getBlockData();
                blockData.setRotation(p.getFacing());
                b.setBlockData((BlockData)blockData);
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv;
                boolean allow;
                boolean bl = allow = reason == UnregisterReason.PLAYER_BREAK && (BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(p.getUniqueId().toString()) || p.hasPermission("slimefun.android.bypass"));
                if (allow && (inv = BlockStorage.getInventory(b)) != null) {
                    if (inv.getItemInSlot(43) != null) {
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(43));
                        inv.replaceExistingItem(43, null);
                    }
                    for (int slot : ProgrammableAndroid.this.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return allow;
            }
        });
    }

    public abstract AndroidType getAndroidType();

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem item, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config data) {
                if (b != null) {
                    ProgrammableAndroid.this.tick(b);
                }
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    public void openScript(Player p, Block b, String script) {
        ChestMenu menu = new ChestMenu(ChatColor.DARK_AQUA + SlimefunPlugin.getLocal().getMessage(p, "android.scripts.editor"));
        menu.addItem(0, (ItemStack)new CustomItem(ScriptAction.START.getItem(), SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions.START"), "", "&7\u21e8 &eLeft Click &7to return to the Android's interface"));
        menu.addMenuClickHandler(0, (pl, slot, item, action) -> {
            BlockStorage.getInventory(b).open(new Player[]{pl});
            return false;
        });
        String[] commands = PatternUtils.DASH.split(script);
        for (int i = 1; i < commands.length; ++i) {
            int index = i;
            if (i == commands.length - 1) {
                int additional;
                int n = additional = commands.length == 54 ? 0 : 1;
                if (additional == 1) {
                    menu.addItem(i, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("171d8979c1878a05987a7faf21b56d1b744f9d068c74cffcde1ea1edad5852"), "&7> Add new Command", new String[0]));
                    menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                        this.openScriptComponentEditor(pl, b, script, index);
                        return false;
                    });
                }
                menu.addItem(i + additional, (ItemStack)new CustomItem(ScriptAction.REPEAT.getItem(), SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions.REPEAT"), "", "&7\u21e8 &eLeft Click &7to return to the Android's interface"));
                menu.addMenuClickHandler(i + additional, (pl, slot, item, action) -> {
                    BlockStorage.getInventory(b).open(new Player[]{pl});
                    return false;
                });
                continue;
            }
            ItemStack stack = ScriptAction.valueOf(commands[i]).getItem();
            menu.addItem(i, (ItemStack)new CustomItem(stack, SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions." + ScriptAction.valueOf(commands[i]).name()), "", "&7\u21e8 &eLeft Click &7to edit", "&7\u21e8 &eRight Click &7to delete", "&7\u21e8 &eShift + Right Click &7to duplicate"));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> {
                if (action.isRightClicked() && action.isShiftClicked()) {
                    if (commands.length == 54) {
                        return false;
                    }
                    int j = 0;
                    StringBuilder builder = new StringBuilder((Object)((Object)ScriptAction.START) + "-");
                    for (String command : commands) {
                        if (j > 0) {
                            if (j == index) {
                                builder.append(commands[j]).append('-').append(commands[j]).append('-');
                            } else if (j < commands.length - 1) {
                                builder.append(command).append('-');
                            }
                        }
                        ++j;
                    }
                    builder.append((Object)ScriptAction.REPEAT);
                    this.setScript(b.getLocation(), builder.toString());
                    this.openScript(pl, b, builder.toString());
                } else if (action.isRightClicked()) {
                    int j = 0;
                    StringBuilder builder = new StringBuilder((Object)((Object)ScriptAction.START) + "-");
                    for (String command : commands) {
                        if (j != index && j > 0 && j < commands.length - 1) {
                            builder.append(command).append('-');
                        }
                        ++j;
                    }
                    builder.append((Object)ScriptAction.REPEAT);
                    this.setScript(b.getLocation(), builder.toString());
                    this.openScript(pl, b, builder.toString());
                } else {
                    this.openScriptComponentEditor(pl, b, script, index);
                }
                return false;
            });
        }
        menu.open(new Player[]{p});
    }

    protected void openScriptDownloader(Player p, Block b, int page) {
        int target;
        ChestMenu menu = new ChestMenu("Android Scripts");
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 0.7f, 0.7f));
        List<Config> scripts = this.getUploadedScripts();
        int pages = scripts.size() / 45 + 1;
        for (int i = 45; i < 54; ++i) {
            menu.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]));
            menu.addMenuClickHandler(i, (pl, slot, item, action) -> false);
        }
        menu.addItem(46, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&r\u21e6 Previous Page", "", "&7(" + page + " / " + pages + ")"));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next < 1) {
                next = pages;
            }
            if (next != page) {
                this.openScriptDownloader(pl, b, next);
            }
            return false;
        });
        menu.addItem(48, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("105a2cab8b68ea57e3af992a36e47c8ff9aa87cc8776281966f8c3cf31a38"), "&eUpload a Script", "", "&6Click &7to upload your Android's Script", "&7to the Database"));
        menu.addMenuClickHandler(48, (pl, slot, item, action) -> {
            this.uploadScript(pl, b, page);
            return false;
        });
        menu.addItem(50, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), "&rNext Page \u21e8", "", "&7(" + page + " / " + pages + ")"));
        menu.addMenuClickHandler(50, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next > pages) {
                next = 1;
            }
            if (next != page) {
                this.openScriptDownloader(pl, b, next);
            }
            return false;
        });
        menu.addItem(53, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("185c97dbb8353de652698d24b64327b793a3f32a98be67b719fbedab35e"), "&6> Back", "", "&7Return to the Android's interface"));
        menu.addMenuClickHandler(53, (pl, slot, item, action) -> {
            this.openScriptEditor(pl, b);
            return false;
        });
        int index = 0;
        int categoryIndex = 45 * (page - 1);
        for (int i = 0; i < 45 && (target = categoryIndex + i) < scripts.size(); ++i) {
            String author;
            Config script = scripts.get(target);
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)script.getUUID("author"));
            String string = author = op != null && op.getName() != null ? op.getName() : script.getString("author_name");
            if (script.getString("author").equals(p.getUniqueId().toString())) {
                menu.addItem(index, (ItemStack)new CustomItem(this.getItem(), "&b" + script.getString("name"), "&7by &r" + author, "", "&7Downloads: &r" + script.getInt("downloads"), "&7Rating: " + this.getScriptRatingPercentage(script), "&a" + this.getScriptRating(script, true) + " \u263a &7| &4\u2639 " + this.getScriptRating(script, false), "", "&eLeft Click &rto download this Script", "&4(This will override your current Script)"));
            } else {
                menu.addItem(index, (ItemStack)new CustomItem(this.getItem(), "&b" + script.getString("name"), "&7by &r" + author, "", "&7Downloads: &r" + script.getInt("downloads"), "&7Rating: " + this.getScriptRatingPercentage(script), "&a" + this.getScriptRating(script, true) + " \u263a &7| &4\u2639 " + this.getScriptRating(script, false), "", "&eLeft Click &rto download this Script", "&4(This will override your current Script)", "&eShift + Left Click &rto leave a positive Rating", "&eShift + Right Click &rto leave a negative Rating"));
            }
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                Config script2 = new Config(script.getFile());
                if (action.isShiftClicked()) {
                    if (script2.getString("author").equals(pl.getUniqueId().toString())) {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.own", true);
                    } else if (action.isRightClicked()) {
                        if (!script2.getStringList("rating.negative").contains(pl.getUniqueId().toString()) && !script2.getStringList("rating.positive").contains(pl.getUniqueId().toString())) {
                            List<String> list = script2.getStringList("rating.negative");
                            list.add(p.getUniqueId().toString());
                            script2.setValue("rating.negative", list);
                            script2.save();
                            this.openScriptDownloader(pl, b, page);
                        } else {
                            SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.already", true);
                        }
                    } else if (!script2.getStringList("rating.negative").contains(pl.getUniqueId().toString()) && !script2.getStringList("rating.positive").contains(pl.getUniqueId().toString())) {
                        List<String> list = script2.getStringList("rating.positive");
                        list.add(pl.getUniqueId().toString());
                        script2.setValue("rating.positive", list);
                        script2.save();
                        this.openScriptDownloader(pl, b, page);
                    } else {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)pl, "android.scripts.rating.already", true);
                    }
                } else if (!action.isRightClicked()) {
                    script2.setValue("downloads", script2.getInt("downloads") + 1);
                    script2.save();
                    this.setScript(b.getLocation(), script2.getString("code"));
                    this.openScriptEditor(pl, b);
                }
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    private void uploadScript(Player p, Block b, int page) {
        String code = this.getScript(b.getLocation());
        int num = 1;
        for (Config script : this.getUploadedScripts()) {
            if (script.getString("author").equals(p.getUniqueId().toString())) {
                ++num;
            }
            if (!script.getString("code").equals(code)) continue;
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "android.scripts.already-uploaded", true);
            return;
        }
        int id = num;
        p.closeInventory();
        SlimefunPlugin.getLocal().sendMessages((CommandSender)p, "android.scripts.enter-name");
        ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, p, msg -> {
            Config script = new Config("plugins/Slimefun/scripts/" + this.getAndroidType().toString() + '/' + p.getName() + ' ' + id + ".sfs");
            script.setValue("author", p.getUniqueId().toString());
            script.setValue("author_name", p.getName());
            script.setValue("name", ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)msg)));
            script.setValue("code", code);
            script.setValue("downloads", 0);
            script.setValue("android", this.getAndroidType().toString());
            script.setValue("rating.positive", new ArrayList());
            script.setValue("rating.negative", new ArrayList());
            script.save();
            SlimefunPlugin.getLocal().sendMessages((CommandSender)p, "android.scripts.uploaded");
            this.openScriptDownloader(p, b, page);
        });
    }

    public void openScriptEditor(Player p, Block b) {
        ChestMenu menu = new ChestMenu(ChatColor.DARK_AQUA + SlimefunPlugin.getLocal().getMessage(p, "android.scripts.editor"));
        menu.addItem(1, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("d9bf6db4aeda9d8822b9f736538e8c18b9a4844f84eb45504adfbfee87eb"), "&2> Edit Script", "", "&aEdits your current Script"));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            this.openScript(pl, b, this.getScript(b.getLocation()));
            return false;
        });
        menu.addItem(3, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("171d8979c1878a05987a7faf21b56d1b744f9d068c74cffcde1ea1edad5852"), "&4> Create new Script", "", "&cDeletes your current Script", "&cand creates a blank one"));
        menu.addMenuClickHandler(3, (pl, slot, item, action) -> {
            this.openScript(pl, b, "START-TURN_LEFT-REPEAT");
            return false;
        });
        menu.addItem(5, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("c01586e39f6ffa63b4fb301b65ca7da8a92f7353aaab89d3886579125dfbaf9"), "&6> Download a Script", "", "&eDownload a Script from the Server", "&eYou can edit or simply use it"));
        menu.addMenuClickHandler(5, (pl, slot, item, action) -> {
            this.openScriptDownloader(pl, b, 1);
            return false;
        });
        menu.addItem(8, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("a185c97dbb8353de652698d24b64327b793a3f32a98be67b719fbedab35e"), "&6> Back", "", "&7Return to the Android's interface"));
        menu.addMenuClickHandler(8, (pl, slot, item, action) -> {
            BlockStorage.getInventory(b).open(new Player[]{p});
            return false;
        });
        menu.open(new Player[]{p});
    }

    protected List<Config> getUploadedScripts() {
        ArrayList<Config> scripts = new ArrayList<Config>();
        File directory = new File("plugins/Slimefun/scripts/" + this.getAndroidType().toString());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (File script2 : directory.listFiles()) {
            if (!script2.getName().endsWith("sfs")) continue;
            scripts.add(new Config(script2));
        }
        if (this.getAndroidType() != AndroidType.NONE) {
            File mainDirectory = new File("plugins/Slimefun/scripts/NONE");
            if (!mainDirectory.exists()) {
                mainDirectory.mkdirs();
            }
            for (File script3 : mainDirectory.listFiles()) {
                if (!script3.getName().endsWith("sfs")) continue;
                scripts.add(new Config(script3));
            }
        }
        Collections.sort(scripts, Comparator.comparingInt(script -> -(this.getScriptRating((Config)script, true) + 1 - this.getScriptRating((Config)script, false))));
        return scripts;
    }

    protected List<ScriptAction> getAccessibleScriptParts() {
        ArrayList<ScriptAction> list = new ArrayList<ScriptAction>();
        for (ScriptAction part : ScriptAction.values()) {
            if (part == ScriptAction.START || part == ScriptAction.REPEAT || !this.getAndroidType().isType(part.getRequiredType())) continue;
            list.add(part);
        }
        return list;
    }

    protected float getScriptRating(Config script) {
        int positive = this.getScriptRating(script, true) + 1;
        int negative = this.getScriptRating(script, false);
        return (float)Math.round((double)positive / (double)(positive + negative) * 100.0) / 100.0f;
    }

    protected int getScriptRating(Config script, boolean positive) {
        if (positive) {
            return script.getStringList("rating.positive").size();
        }
        return script.getStringList("rating.negative").size();
    }

    protected String getScriptRatingPercentage(Config script) {
        String progress = String.valueOf(this.getScriptRating(script));
        progress = Float.parseFloat(progress) < 16.0f ? "&4" + progress + "&r% " : (Float.parseFloat(progress) < 32.0f ? "&c" + progress + "&r% " : (Float.parseFloat(progress) < 48.0f ? "&6" + progress + "&r% " : (Float.parseFloat(progress) < 64.0f ? "&e" + progress + "&r% " : (Float.parseFloat(progress) < 80.0f ? "&2" + progress + "&r% " : "&a" + progress + "&r% "))));
        return progress;
    }

    protected void openScriptComponentEditor(Player p, Block b, String script, int index) {
        ChestMenu menu = new ChestMenu(ChatColor.DARK_AQUA + SlimefunPlugin.getLocal().getMessage(p, "android.scripts.editor"));
        String[] commands = PatternUtils.DASH.split(script);
        ChestMenuUtils.drawBackground(menu, 0, 1, 2, 3, 4, 5, 6, 7, 8);
        menu.addItem(9, (ItemStack)new CustomItem(SlimefunUtils.getCustomHead("16139fd1c5654e56e9e4e2c8be7eb2bd5b499d633616663feee99b74352ad64"), "&rDo nothing", new String[0]), (pl, slot, item, action) -> {
            int i = 0;
            StringBuilder builder = new StringBuilder("START-");
            for (String command : commands) {
                if (i != index && i > 0 && i < commands.length - 1) {
                    builder.append(command).append('-');
                }
                ++i;
            }
            builder.append("REPEAT");
            this.setScript(b.getLocation(), builder.toString());
            this.openScript(p, b, builder.toString());
            return false;
        });
        int i = 10;
        for (ScriptAction part : this.getAccessibleScriptParts()) {
            menu.addItem(i, (ItemStack)new CustomItem(part.getItem(), SlimefunPlugin.getLocal().getMessage(p, "android.scripts.instructions." + part.name()), new String[0]), (pl, slot, item, action) -> {
                this.addInstruction(pl, b, index, part, commands);
                return false;
            });
            ++i;
        }
        menu.open(new Player[]{p});
    }

    private void addInstruction(Player p, Block b, int index, ScriptAction part, String[] commands) {
        int j = 0;
        StringBuilder builder = new StringBuilder("START-");
        for (String command : commands) {
            if (j > 0) {
                if (j == index) {
                    builder.append((Object)part).append('-');
                } else if (j < commands.length - 1) {
                    builder.append(command).append('-');
                }
            }
            ++j;
        }
        builder.append("REPEAT");
        this.setScript(b.getLocation(), builder.toString());
        this.openScript(p, b, builder.toString());
    }

    protected String getScript(Location l) {
        return BlockStorage.getLocationInfo(l, "script");
    }

    protected void setScript(Location l, String script) {
        BlockStorage.addBlockInfo(l, "script", script);
    }

    private void registerDefaultFuelTypes() {
        if (this.getTier() == 1) {
            this.registerFuelType(new MachineFuel(800, new ItemStack(Material.COAL_BLOCK)));
            this.registerFuelType(new MachineFuel(45, new ItemStack(Material.BLAZE_ROD)));
            this.registerFuelType(new MachineFuel(8, new ItemStack(Material.COAL)));
            this.registerFuelType(new MachineFuel(8, new ItemStack(Material.CHARCOAL)));
            for (Material mat : Tag.LOGS.getValues()) {
                this.registerFuelType(new MachineFuel(2, new ItemStack(mat)));
            }
            for (Material mat : Tag.PLANKS.getValues()) {
                this.registerFuelType(new MachineFuel(1, new ItemStack(mat)));
            }
        } else if (this.getTier() == 2) {
            this.registerFuelType(new MachineFuel(100, new ItemStack(Material.LAVA_BUCKET)));
            this.registerFuelType(new MachineFuel(200, SlimefunItems.BUCKET_OF_OIL));
            this.registerFuelType(new MachineFuel(500, SlimefunItems.BUCKET_OF_FUEL));
        } else {
            this.registerFuelType(new MachineFuel(2500, SlimefunItems.URANIUM));
            this.registerFuelType(new MachineFuel(1200, SlimefunItems.NEPTUNIUM));
            this.registerFuelType(new MachineFuel(3000, SlimefunItems.BOOSTED_URANIUM));
        }
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.fuelTypes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColors.color("&8\u21e8 &7Lasts " + NumberUtils.getTimeLeft(fuel.getTicks() / 2)));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{20, 21, 22, 29, 30, 31};
    }

    public abstract float getFuelEfficiency();

    public abstract int getTier();

    protected void tick(Block b) {
        if (b.getType() != Material.PLAYER_HEAD) {
            return;
        }
        if ("false".equals(BlockStorage.getLocationInfo(b.getLocation(), "paused"))) {
            BlockMenu menu = BlockStorage.getInventory(b);
            float fuel = Float.parseFloat(BlockStorage.getLocationInfo(b.getLocation(), "fuel"));
            if ((double)fuel < 0.001) {
                this.consumeFuel(b, menu);
            } else {
                String[] script = PatternUtils.DASH.split(BlockStorage.getLocationInfo(b.getLocation(), "script"));
                int index = Integer.parseInt(BlockStorage.getLocationInfo(b.getLocation(), "index")) + 1;
                if (index >= script.length) {
                    index = 0;
                }
                boolean refresh = true;
                BlockStorage.addBlockInfo(b, "fuel", String.valueOf(fuel - 1.0f));
                ScriptAction part = ScriptAction.valueOf(script[index]);
                if (this.getAndroidType().isType(part.getRequiredType())) {
                    BlockFace face = BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"));
                    double damage = this.getTier() >= 3 ? 20.0 : 4.0 * (double)this.getTier();
                    switch (part) {
                        case GO_DOWN: {
                            this.move(b, face, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case GO_FORWARD: {
                            this.move(b, face, b.getRelative(face));
                            break;
                        }
                        case GO_UP: {
                            this.move(b, face, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case REPEAT: {
                            BlockStorage.addBlockInfo(b, "index", String.valueOf(0));
                            break;
                        }
                        case TURN_LEFT: {
                            int indexLeft = POSSIBLE_ROTATIONS.indexOf(BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) - 1;
                            if (indexLeft < 0) {
                                indexLeft = POSSIBLE_ROTATIONS.size() - 1;
                            }
                            Rotatable rotatableLeft = (Rotatable)b.getBlockData();
                            rotatableLeft.setRotation(POSSIBLE_ROTATIONS.get(indexLeft));
                            b.setBlockData((BlockData)rotatableLeft);
                            BlockStorage.addBlockInfo(b, "rotation", POSSIBLE_ROTATIONS.get(indexLeft).toString());
                            break;
                        }
                        case TURN_RIGHT: {
                            int indexRight = POSSIBLE_ROTATIONS.indexOf(BlockFace.valueOf((String)BlockStorage.getLocationInfo(b.getLocation(), "rotation"))) + 1;
                            if (indexRight == POSSIBLE_ROTATIONS.size()) {
                                indexRight = 0;
                            }
                            Rotatable rotatableRight = (Rotatable)b.getBlockData();
                            rotatableRight.setRotation(POSSIBLE_ROTATIONS.get(indexRight));
                            b.setBlockData((BlockData)rotatableRight);
                            BlockStorage.addBlockInfo(b, "rotation", POSSIBLE_ROTATIONS.get(indexRight).toString());
                            break;
                        }
                        case DIG_FORWARD: {
                            this.mine(b, menu, b.getRelative(face));
                            break;
                        }
                        case DIG_UP: {
                            this.mine(b, menu, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case DIG_DOWN: {
                            this.mine(b, menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case CATCH_FISH: {
                            this.fish(b, menu);
                            break;
                        }
                        case MOVE_AND_DIG_FORWARD: {
                            this.movedig(b, menu, face, b.getRelative(face));
                            break;
                        }
                        case MOVE_AND_DIG_UP: {
                            this.movedig(b, menu, face, b.getRelative(BlockFace.UP));
                            break;
                        }
                        case MOVE_AND_DIG_DOWN: {
                            this.movedig(b, menu, face, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case INTERFACE_ITEMS: {
                            this.depositItems(menu, b.getRelative(face));
                            break;
                        }
                        case INTERFACE_FUEL: {
                            this.refuel(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_FORWARD: {
                            this.farm(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_DOWN: {
                            this.farm(menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case FARM_EXOTIC_FORWARD: {
                            this.exoticFarm(menu, b.getRelative(face));
                            break;
                        }
                        case FARM_EXOTIC_DOWN: {
                            this.exoticFarm(menu, b.getRelative(BlockFace.DOWN));
                            break;
                        }
                        case CHOP_TREE: {
                            refresh = this.chopTree(b, menu, face);
                            break;
                        }
                        case ATTACK_MOBS_ANIMALS: {
                            this.killEntities(b, damage, e -> true);
                            break;
                        }
                        case ATTACK_MOBS: {
                            this.killEntities(b, damage, e -> e instanceof Monster);
                            break;
                        }
                        case ATTACK_ANIMALS: {
                            this.killEntities(b, damage, e -> e instanceof Animals);
                            break;
                        }
                        case ATTACK_ANIMALS_ADULT: {
                            this.killEntities(b, damage, e -> e instanceof Animals && e instanceof Ageable && ((Ageable)e).isAdult());
                            break;
                        }
                    }
                }
                if (refresh) {
                    BlockStorage.addBlockInfo(b, "index", String.valueOf(index));
                }
            }
        }
    }

    private void depositItems(BlockMenu menu, Block facedBlock) {
        if (facedBlock.getType() == Material.DISPENSER && BlockStorage.check(facedBlock, "ANDROID_INTERFACE_ITEMS")) {
            Dispenser d = (Dispenser)facedBlock.getState();
            for (int slot : this.getOutputSlots()) {
                ItemStack stack = menu.getItemInSlot(slot);
                if (stack == null) continue;
                Optional optional = d.getInventory().addItem(new ItemStack[]{stack}).values().stream().findFirst();
                if (optional.isPresent()) {
                    menu.replaceExistingItem(slot, (ItemStack)optional.get());
                    continue;
                }
                menu.replaceExistingItem(slot, null);
            }
        }
    }

    private void consumeFuel(Block b, BlockMenu menu) {
        ItemStack item = menu.getItemInSlot(43);
        if (item != null) {
            for (MachineFuel fuel : this.fuelTypes) {
                if (!fuel.test(item)) continue;
                menu.consumeItem(43);
                if (this.getTier() == 2) {
                    menu.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
                }
                BlockStorage.addBlockInfo(b, "fuel", String.valueOf((int)((float)fuel.getTicks() * this.getFuelEfficiency())));
                break;
            }
        }
    }

    private void refuel(BlockMenu menu, Block facedBlock) {
        if (facedBlock.getType() == Material.DISPENSER && BlockStorage.check(facedBlock, "ANDROID_INTERFACE_FUEL")) {
            Dispenser d = (Dispenser)facedBlock.getState();
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack item = d.getInventory().getItem(slot);
                if (item == null) continue;
                this.insertFuel(menu, d.getInventory(), slot, menu.getItemInSlot(43), item);
            }
        }
    }

    private boolean insertFuel(BlockMenu menu, Inventory dispenser, int slot, ItemStack currentFuel, ItemStack newFuel) {
        if (currentFuel == null) {
            menu.replaceExistingItem(43, newFuel);
            dispenser.setItem(slot, null);
            return true;
        }
        if (SlimefunUtils.isItemSimilar(newFuel, currentFuel, true)) {
            int rest = newFuel.getType().getMaxStackSize() - currentFuel.getAmount();
            if (rest > 0) {
                int amount = newFuel.getAmount() > rest ? rest : newFuel.getAmount();
                menu.replaceExistingItem(43, new CustomItem(newFuel, currentFuel.getAmount() + amount));
                ItemUtils.consumeItem(newFuel, amount, false);
            }
            return true;
        }
        return false;
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : BORDER) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : OUTPUT_BORDER) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        ItemStack generator = SlimefunUtils.getCustomHead("9343ce58da54c79924a2c9331cfc417fe8ccbbea9be45a7ac85860a6c730");
        if (this.getTier() == 1) {
            preset.addItem(34, new CustomItem(generator, "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on solid Fuel", "&re.g. Coal, Wood, etc..."), ChestMenuUtils.getEmptyClickHandler());
        } else if (this.getTier() == 2) {
            preset.addItem(34, new CustomItem(generator, "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on liquid Fuel", "&re.g. Lava, Oil, Fuel, etc..."), ChestMenuUtils.getEmptyClickHandler());
        } else {
            preset.addItem(34, new CustomItem(generator, "&8\u21e9 &cFuel Input &8\u21e9", "", "&rThis Android runs on radioactive Fuel", "&re.g. Uranium, Neptunium or Boosted Uranium"), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public void addItems(Block b, ItemStack ... items) {
        BlockMenu inv = BlockStorage.getInventory(b);
        for (ItemStack item : items) {
            inv.pushItem(item, this.getOutputSlots());
        }
    }

    public void registerFuelType(MachineFuel fuel) {
        this.fuelTypes.add(fuel);
    }

    protected void move(Block b, BlockFace face, Block block) {
        if (block.getY() > 0 && block.getY() < block.getWorld().getMaxHeight() && (block.getType() == Material.AIR || block.getType() == Material.CAVE_AIR)) {
            block.setType(Material.PLAYER_HEAD);
            Rotatable blockData = (Rotatable)block.getBlockData();
            blockData.setRotation(face.getOppositeFace());
            block.setBlockData((BlockData)blockData);
            SkullBlock.setFromBase64(block, this.texture);
            b.setType(Material.AIR);
            BlockStorage.moveBlockInfo(b.getLocation(), block.getLocation());
        }
    }

    protected void killEntities(Block b, double damage, Predicate<Entity> predicate) {
        throw new UnsupportedOperationException("Non-butcher Android tried to butcher!");
    }

    protected void fish(Block b, BlockMenu menu) {
        throw new UnsupportedOperationException("Non-fishing Android tried to fish!");
    }

    protected void mine(Block b, BlockMenu menu, Block block) {
        throw new UnsupportedOperationException("Non-mining Android tried to mine!");
    }

    protected void movedig(Block b, BlockMenu menu, BlockFace face, Block block) {
        throw new UnsupportedOperationException("Non-mining Android tried to mine!");
    }

    protected boolean chopTree(Block b, BlockMenu menu, BlockFace face) {
        throw new UnsupportedOperationException("Non-woodcutter Android tried to chop a Tree!");
    }

    protected void farm(BlockMenu menu, Block block) {
        throw new UnsupportedOperationException("Non-farming Android tried to farm!");
    }

    protected void exoticFarm(BlockMenu menu, Block block) {
        throw new UnsupportedOperationException("Non-farming Android tried to farm!");
    }
}

