/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.MultiBlockInteractEvent;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import java.util.LinkedList;
import me.mrCookieSlime.Slimefun.Objects.handlers.MultiBlockInteractionHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class MultiBlockListener
implements Listener {
    public MultiBlockListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player p = e.getPlayer();
        Block b = e.getClickedBlock();
        LinkedList<MultiBlock> multiblocks = new LinkedList<MultiBlock>();
        for (MultiBlock mb : SlimefunPlugin.getRegistry().getMultiBlocks()) {
            Block center = b.getRelative(mb.getTriggerBlock());
            if (!this.compareMaterials(center, mb.getStructure(), mb.isSymmetric())) continue;
            multiblocks.add(mb);
        }
        if (!multiblocks.isEmpty()) {
            e.setCancelled(true);
            MultiBlock mb = (MultiBlock)multiblocks.getLast();
            mb.getSlimefunItem().callItemHandler(MultiBlockInteractionHandler.class, handler -> handler.onInteract(p, mb, b));
            Bukkit.getPluginManager().callEvent((Event)new MultiBlockInteractEvent(p, mb, b, e.getBlockFace()));
        }
    }

    private boolean compareMaterials(Block b, Material[] blocks, boolean onlyTwoWay) {
        BlockFace[] directions;
        BlockFace[] blockFaceArray;
        if (!this.compareMaterialsVertical(b, blocks[1], blocks[4], blocks[7])) {
            return false;
        }
        if (onlyTwoWay) {
            BlockFace[] blockFaceArray2 = new BlockFace[2];
            blockFaceArray2[0] = BlockFace.NORTH;
            blockFaceArray = blockFaceArray2;
            blockFaceArray2[1] = BlockFace.EAST;
        } else {
            BlockFace[] blockFaceArray3 = new BlockFace[4];
            blockFaceArray3[0] = BlockFace.NORTH;
            blockFaceArray3[1] = BlockFace.EAST;
            blockFaceArray3[2] = BlockFace.SOUTH;
            blockFaceArray = blockFaceArray3;
            blockFaceArray3[3] = BlockFace.WEST;
        }
        for (BlockFace direction : directions = blockFaceArray) {
            if (!this.compareMaterialsVertical(b.getRelative(direction), blocks[0], blocks[3], blocks[6]) || !this.compareMaterialsVertical(b.getRelative(direction.getOppositeFace()), blocks[2], blocks[5], blocks[8])) continue;
            return true;
        }
        return false;
    }

    private boolean compareMaterialsVertical(Block b, Material top, Material center, Material bottom) {
        return !(center != null && !this.equals(b.getType(), center) || top != null && !this.equals(b.getRelative(BlockFace.UP).getType(), top) || bottom != null && !this.equals(b.getRelative(BlockFace.DOWN).getType(), bottom));
    }

    private boolean equals(Material a, Material b) {
        if (a == b) {
            return true;
        }
        for (Tag<Material> tag : MultiBlock.getSupportedTags()) {
            if (!tag.isTagged((Keyed)a) || !tag.isTagged((Keyed)b)) continue;
            return true;
        }
        return false;
    }
}

