/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.energy;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AReactor;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class EnergyNet
extends Network {
    private static final int RANGE = 6;
    private final Set<Location> generators = new HashSet<Location>();
    private final Set<Location> storage = new HashSet<Location>();
    private final Set<Location> consumers = new HashSet<Location>();

    public static EnergyNetComponentType getComponent(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return EnergyNetComponentType.NONE;
        }
        if (SlimefunPlugin.getRegistry().getEnergyGenerators().contains(id)) {
            return EnergyNetComponentType.GENERATOR;
        }
        if (SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(id)) {
            return EnergyNetComponentType.CAPACITOR;
        }
        if (SlimefunPlugin.getRegistry().getEnergyConsumers().contains(id)) {
            return EnergyNetComponentType.CONSUMER;
        }
        return EnergyNetComponentType.NONE;
    }

    public static EnergyNet getNetworkFromLocationOrCreate(Location l) {
        Optional<EnergyNet> cargoNetwork = SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, EnergyNet.class);
        if (cargoNetwork.isPresent()) {
            return cargoNetwork.get();
        }
        EnergyNet network = new EnergyNet(l);
        SlimefunPlugin.getNetworkManager().registerNetwork(network);
        return network;
    }

    protected EnergyNet(Location l) {
        super(SlimefunPlugin.getNetworkManager(), l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        if (this.regulator.equals((Object)l)) {
            return NetworkComponent.REGULATOR;
        }
        switch (EnergyNet.getComponent(l)) {
            case CAPACITOR: {
                return NetworkComponent.CONNECTOR;
            }
            case CONSUMER: 
            case GENERATOR: {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.generators.remove(l);
            this.consumers.remove(l);
        }
        switch (EnergyNet.getComponent(l)) {
            case CAPACITOR: {
                this.storage.add(l);
                break;
            }
            case CONSUMER: {
                this.consumers.add(l);
                break;
            }
            case GENERATOR: {
                this.generators.add(l);
                break;
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Energy Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&4No Energy Network found");
        } else {
            int capacity;
            double supply = DoubleHandler.fixDouble(this.tickAllGenerators() + this.tickAllCapacitors());
            double demand = 0.0;
            int available = (int)supply;
            for (Location destination : this.consumers) {
                capacity = ChargableBlock.getMaxCharge(destination);
                int charge = ChargableBlock.getCharge(destination);
                if (charge >= capacity) continue;
                int rest = capacity - charge;
                demand += (double)rest;
                if (available <= 0) continue;
                if (available > rest) {
                    ChargableBlock.setUnsafeCharge(destination, capacity, false);
                    available -= rest;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(destination, charge + available, false);
                available = 0;
            }
            for (Location battery : this.storage) {
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(battery);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(battery, capacity, true);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(battery, available, true);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(battery, 0, true);
            }
            for (Location source : this.generators) {
                if (!ChargableBlock.isChargable(source)) continue;
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(source);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(source, capacity, false);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(source, available, false);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(source, 0, false);
            }
            this.updateHologram(b, supply, demand);
        }
    }

    private double tickAllGenerators() {
        double supply = 0.0;
        HashSet<Location> exploded = new HashSet<Location>();
        for (Location source : this.generators) {
            long timestamp = System.currentTimeMillis();
            SlimefunItem item = BlockStorage.check(source);
            Config config = BlockStorage.getLocationInfo(source);
            try {
                GeneratorTicker generator = item.getEnergyTicker();
                if (generator != null) {
                    double energy = generator.generateEnergy(source, item, config);
                    if (generator.explode(source)) {
                        exploded.add(source);
                        BlockStorage.clearBlockInfo(source);
                        AReactor.processing.remove(source);
                        AReactor.progress.remove(source);
                        Slimefun.runSync(() -> {
                            source.getBlock().setType(Material.LAVA);
                            source.getWorld().createExplosion(source, 0.0f, false);
                        });
                    } else {
                        supply += energy;
                    }
                } else {
                    item.warn("This Item was marked as a 'GENERATOR' but has no 'GeneratorTicker' attached to it! This must be fixed.");
                }
            }
            catch (Throwable t) {
                exploded.add(source);
                new ErrorReport(t, source, item);
            }
            SlimefunPlugin.getTicker().addBlockTimings(source, System.currentTimeMillis() - timestamp);
        }
        this.generators.removeAll(exploded);
        return supply;
    }

    private double tickAllCapacitors() {
        double supply = 0.0;
        for (Location battery : this.storage) {
            supply += (double)ChargableBlock.getCharge(battery);
        }
        return supply;
    }

    private void updateHologram(Block b, double supply, double demand) {
        if (demand > supply) {
            String netLoss = DoubleHandler.getFancyDouble(Math.abs(supply - demand));
            SimpleHologram.update(b, "&4&l- &c" + netLoss + " &7J &e\u26a1");
        } else {
            String netGain = DoubleHandler.getFancyDouble(supply - demand);
            SimpleHologram.update(b, "&2&l+ &a" + netGain + " &7J &e\u26a1");
        }
    }
}

