/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection.modules;

import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GriefPreventionProtectionModule
implements ProtectionModule {
    private DataStore dataStore;
    private final Plugin plugin;

    public GriefPreventionProtectionModule(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.dataStore = GriefPrevention.instance.dataStore;
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, ProtectableAction action) {
        Claim claim = this.dataStore.getClaimAt(l, true, null);
        if (claim == null) {
            return true;
        }
        if (p.getUniqueId().equals(claim.ownerID)) {
            return true;
        }
        if (!(p instanceof Player)) {
            return false;
        }
        switch (action) {
            case ACCESS_INVENTORIES: {
                return claim.allowContainers((Player)p) == null;
            }
            case PVP: {
                return claim.siegeData.attacker == null;
            }
            case BREAK_BLOCK: {
                return claim.allowBreak((Player)p, l.getBlock().getType()) == null;
            }
        }
        return claim.allowBuild((Player)p, l.getBlock().getType()) == null;
    }
}

