/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SlimefunBootsListener
implements Listener {
    private final Map<String, Predicate<EntityDamageEvent>> cancelledEvents = new HashMap<String, Predicate<EntityDamageEvent>>();

    public SlimefunBootsListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.cancelledEvents.put("ENDER_BOOTS", e -> e instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)e).getDamager() instanceof EnderPearl);
        this.cancelledEvents.put("BOOTS_OF_THE_STOMPER", e -> {
            if (e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                this.stomp((EntityDamageEvent)e);
                return true;
            }
            return false;
        });
        this.cancelledEvents.put("SLIME_BOOTS", e -> e.getCause() == EntityDamageEvent.DamageCause.FALL);
        this.cancelledEvents.put("SLIME_STEEL_BOOTS", e -> e.getCause() == EntityDamageEvent.DamageCause.FALL);
    }

    private void stomp(EntityDamageEvent e) {
        Player p = (Player)e.getEntity();
        p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 2.0f);
        p.setVelocity(new Vector(0.0, 0.7, 0.0));
        for (Entity n : p.getNearbyEntities(4.0, 4.0, 4.0)) {
            if (!(n instanceof LivingEntity) || n.getUniqueId().equals(p.getUniqueId())) continue;
            Vector velocity = n.getLocation().toVector().subtract(p.getLocation().toVector()).normalize().multiply(1.4);
            n.setVelocity(velocity);
            if (n instanceof Player && (!p.getWorld().getPVP() || !SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, n.getLocation(), ProtectableAction.PVP))) continue;
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)p, n, EntityDamageEvent.DamageCause.ENTITY_ATTACK, e.getDamage() / 2.0);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            ((LivingEntity)n).damage(e.getDamage() / 2.0);
        }
        for (BlockFace face : BlockFace.values()) {
            Block b = p.getLocation().getBlock().getRelative(BlockFace.DOWN).getRelative(face);
            p.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent e) {
        Player p;
        SlimefunItem boots;
        if (e.getEntity() instanceof Player && (boots = SlimefunItem.getByItem((p = (Player)e.getEntity()).getInventory().getBoots())) != null) {
            for (Map.Entry<String, Predicate<EntityDamageEvent>> event : this.cancelledEvents.entrySet()) {
                if (!boots.getID().equals(event.getKey())) continue;
                if (!Slimefun.hasUnlocked(p, boots, true) || !event.getValue().test(e)) break;
                e.setCancelled(true);
                break;
            }
        }
    }

    @EventHandler
    public void onTrample(PlayerInteractEvent e) {
        if (e.getAction() != Action.PHYSICAL) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.FARMLAND) {
            return;
        }
        ItemStack boots = e.getPlayer().getInventory().getBoots();
        if (SlimefunUtils.isItemSimilar(boots, SlimefunItems.FARMER_SHOES, true) && Slimefun.hasUnlocked(e.getPlayer(), boots, true)) {
            e.setCancelled(true);
        }
    }
}

