/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

final class CargoUtils {
    private static final int[] SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};

    private CargoUtils() {
    }

    static boolean hasInventory(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        switch (type) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case FURNACE: 
            case DISPENSER: 
            case DROPPER: 
            case HOPPER: 
            case BREWING_STAND: 
            case SHULKER_BOX: {
                return true;
            }
        }
        if (type.name().endsWith("_SHULKER_BOX")) {
            return true;
        }
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            switch (type) {
                case BARREL: 
                case BLAST_FURNACE: 
                case SMOKER: {
                    return true;
                }
            }
        }
        return false;
    }

    static ItemStack withdraw(Block node, Block target, ItemStack template) {
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu == null) {
            BlockState state;
            if (CargoUtils.hasInventory(target) && (state = target.getState()) instanceof InventoryHolder) {
                return CargoUtils.withdrawFromVanillaInventory(node, template, ((InventoryHolder)state).getInventory());
            }
            return null;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(template);
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
            ItemStack is = menu.getItemInSlot(slot);
            if (!SlimefunUtils.isItemSimilar(is, wrapper, true) || !CargoUtils.matchesFilter(node, is, -1)) continue;
            if (is.getAmount() > template.getAmount()) {
                is.setAmount(is.getAmount() - template.getAmount());
                menu.replaceExistingItem(slot, is.clone());
                return template;
            }
            menu.replaceExistingItem(slot, null);
            return is;
        }
        return null;
    }

    static ItemStack withdrawFromVanillaInventory(Block node, ItemStack template, Inventory inv) {
        ItemStack[] contents = inv.getContents();
        int minSlot = 0;
        int maxSlot = contents.length;
        if (inv instanceof FurnaceInventory) {
            minSlot = 2;
            maxSlot = 3;
        } else if (inv instanceof BrewerInventory) {
            maxSlot = 3;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(template);
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack itemInSlot = contents[slot];
            if (!SlimefunUtils.isItemSimilar(itemInSlot, wrapper, true) || !CargoUtils.matchesFilter(node, itemInSlot, -1)) continue;
            if (itemInSlot.getAmount() > template.getAmount()) {
                itemInSlot.setAmount(itemInSlot.getAmount() - template.getAmount());
                return template;
            }
            ItemStack clone = itemInSlot.clone();
            itemInSlot.setAmount(0);
            return clone;
        }
        return null;
    }

    static ItemStackAndInteger withdraw(Block node, Block target, int index) {
        block6: {
            BlockState state;
            block5: {
                DirtyChestMenu menu = CargoUtils.getChestMenu(target);
                if (menu == null) break block5;
                for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                    ItemStack is = menu.getItemInSlot(slot);
                    if (!CargoUtils.matchesFilter(node, is, index)) continue;
                    menu.replaceExistingItem(slot, null);
                    return new ItemStackAndInteger(is, slot);
                }
                break block6;
            }
            if (!CargoUtils.hasInventory(target) || !((state = target.getState()) instanceof InventoryHolder)) break block6;
            Inventory inv = ((InventoryHolder)state).getInventory();
            ItemStack[] contents = inv.getContents();
            int minSlot = 0;
            int maxSlot = contents.length;
            if (inv instanceof FurnaceInventory) {
                minSlot = 2;
                maxSlot = 3;
            } else if (inv instanceof BrewerInventory) {
                maxSlot = 3;
            }
            for (int slot = minSlot; slot < maxSlot; ++slot) {
                ItemStack is = contents[slot];
                if (!CargoUtils.matchesFilter(node, is, index)) continue;
                inv.setItem(slot, null);
                return new ItemStackAndInteger(is, slot);
            }
        }
        return null;
    }

    static ItemStack insert(Block node, Block target, ItemStack stack, int index) {
        if (!CargoUtils.matchesFilter(node, stack, index)) {
            return stack;
        }
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu == null) {
            BlockState state;
            if (CargoUtils.hasInventory(target) && (state = target.getState()) instanceof InventoryHolder) {
                return CargoUtils.insertIntoVanillaInventory(stack, ((InventoryHolder)state).getInventory());
            }
            return stack;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.INSERT, stack)) {
            ItemStack itemInSlot = menu.getItemInSlot(slot);
            if (itemInSlot == null) {
                menu.replaceExistingItem(slot, stack);
                return null;
            }
            int maxStackSize = itemInSlot.getType().getMaxStackSize();
            int currentAmount = itemInSlot.getAmount();
            if (!SlimefunUtils.isItemSimilar(itemInSlot, wrapper, true, false) || currentAmount >= maxStackSize) continue;
            int amount = currentAmount + stack.getAmount();
            itemInSlot.setAmount(Math.min(amount, maxStackSize));
            if (amount > maxStackSize) {
                stack.setAmount(amount - maxStackSize);
            } else {
                stack = null;
            }
            menu.replaceExistingItem(slot, itemInSlot);
            return stack;
        }
        return stack;
    }

    static ItemStack insertIntoVanillaInventory(ItemStack stack, Inventory inv) {
        ItemStack[] contents = inv.getContents();
        int minSlot = 0;
        int maxSlot = contents.length;
        if (inv instanceof FurnaceInventory) {
            if (stack.getType().isFuel()) {
                minSlot = 1;
                maxSlot = 2;
            } else {
                maxSlot = 1;
            }
        } else if (inv instanceof BrewerInventory) {
            if (stack.getType() == Material.POTION || stack.getType() == Material.LINGERING_POTION || stack.getType() == Material.SPLASH_POTION) {
                maxSlot = 3;
            } else if (stack.getType() == Material.BLAZE_POWDER) {
                minSlot = 4;
                maxSlot = 5;
            } else {
                minSlot = 3;
                maxSlot = 4;
            }
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack itemInSlot = contents[slot];
            if (itemInSlot == null) {
                inv.setItem(slot, stack);
                return null;
            }
            int maxStackSize = itemInSlot.getType().getMaxStackSize();
            if (!SlimefunUtils.isItemSimilar(itemInSlot, wrapper, true, false) || itemInSlot.getAmount() >= maxStackSize) continue;
            int amount = itemInSlot.getAmount() + stack.getAmount();
            if (amount > maxStackSize) {
                stack.setAmount(amount - maxStackSize);
            } else {
                stack = null;
            }
            itemInSlot.setAmount(Math.min(amount, maxStackSize));
            inv.setItem(slot, itemInSlot);
            return stack;
        }
        return stack;
    }

    static DirtyChestMenu getChestMenu(Block block) {
        if (BlockStorage.hasInventory(block)) {
            return BlockStorage.getInventory(block);
        }
        return BlockStorage.getUniversalInventory(block);
    }

    static boolean matchesFilter(Block block, ItemStack item, int index) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        Config blockInfo = BlockStorage.getLocationInfo(block.getLocation());
        if (blockInfo.getString("id").equals("CARGO_NODE_OUTPUT")) {
            return true;
        }
        BlockMenu menu = BlockStorage.getInventory(block.getLocation());
        if (menu == null) {
            return false;
        }
        boolean lore = "true".equals(blockInfo.getString("filter-lore"));
        if ("whitelist".equals(blockInfo.getString("filter-type"))) {
            ArrayList<ItemStack> templateItems = new ArrayList<ItemStack>();
            for (int slot : SLOTS) {
                ItemStack template = menu.getItemInSlot(slot);
                if (template == null) continue;
                templateItems.add(template);
            }
            if (templateItems.isEmpty()) {
                return false;
            }
            if (index >= 0) {
                if (++index > templateItems.size() - 1) {
                    index = 0;
                }
                blockInfo.setValue("index", (Object)String.valueOf(index));
                BlockStorage.setBlockInfo(block, blockInfo, false);
                return SlimefunUtils.isItemSimilar(item, (ItemStack)templateItems.get(index), lore);
            }
            Object object = templateItems.iterator();
            while (object.hasNext()) {
                ItemStack stack = (ItemStack)object.next();
                if (!SlimefunUtils.isItemSimilar(item, stack, lore)) continue;
                return true;
            }
            return false;
        }
        for (int slot : SLOTS) {
            ItemStack itemInSlot = menu.getItemInSlot(slot);
            if (itemInSlot == null || !SlimefunUtils.isItemSimilar(item, itemInSlot, lore, false)) continue;
            return false;
        }
        return true;
    }
}

