/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.events.WaypointCreateEvent;
import io.github.thebusybiscuit.slimefun4.api.geo.ResourceManager;
import io.github.thebusybiscuit.slimefun4.api.gps.TeleportationManager;
import io.github.thebusybiscuit.slimefun4.implementation.items.gps.GPSTransmitter;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GPSNetwork {
    private static final String WAYPOINTS_DIRECTORY = "data-storage/Slimefun/waypoints/";
    private final int[] border = new int[]{0, 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] inventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final Map<UUID, Set<Location>> transmitters = new HashMap<UUID, Set<Location>>();
    private final TeleportationManager teleportation = new TeleportationManager(this);
    private final ResourceManager resourceManager = new ResourceManager(SlimefunPlugin.instance);
    private final ItemStack deathpointIcon = SkullItem.fromHash("1ae3855f952cd4a03c148a946e3f812a5955ad35cbcb52627ea4acd47d3081");
    private final ItemStack netherIcon = SkullItem.fromHash("d83571ff589f1a59bb02b80800fc736116e27c3dcf9efebede8cf1fdde");
    private final ItemStack endIcon = SkullItem.fromHash("c6cac59b2aae489aa0687b5d802b2555eb14a40bd62b21eb116fa569cdb756");
    private final ItemStack worldIcon = SkullItem.fromHash("c9c8881e42915a9d29bb61a16fb26d059913204d265df5b439b3d792acd56");

    public void updateTransmitter(Location l, UUID uuid, boolean online) {
        Set set = this.transmitters.computeIfAbsent(uuid, id -> new HashSet());
        if (online) {
            set.add(l);
        } else {
            set.remove(l);
        }
    }

    public int getNetworkComplexity(UUID uuid) {
        if (!this.transmitters.containsKey(uuid)) {
            return 0;
        }
        int level = 0;
        for (Location l : this.transmitters.get(uuid)) {
            SlimefunItem item = BlockStorage.check(l);
            if (!(item instanceof GPSTransmitter)) continue;
            level += ((GPSTransmitter)item).getMultiplier(l.getBlockY());
        }
        return level;
    }

    public int countTransmitters(UUID uuid) {
        if (!this.transmitters.containsKey(uuid)) {
            return 0;
        }
        return this.transmitters.get(uuid).size();
    }

    public void openTransmitterControlPanel(Player p) {
        ChestMenu menu = new ChestMenu(ChatColor.BLUE + SlimefunPlugin.getLocal().getMessage(p, "machines.GPS_CONTROL_PANEL.title"));
        for (int slot2 : this.border) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(2, (ItemStack)new CustomItem(SlimefunItems.GPS_TRANSMITTER, im -> {
            im.setDisplayName(ChatColor.GRAY + SlimefunPlugin.getLocal().getMessage(p, "machines.GPS_CONTROL_PANEL.transmitters"));
            im.setLore(null);
        }));
        menu.addMenuClickHandler(2, ChestMenuUtils.getEmptyClickHandler());
        int complexity = this.getNetworkComplexity(p.getUniqueId());
        menu.addItem(4, (ItemStack)new CustomItem((ItemStack)SlimefunItems.GPS_CONTROL_PANEL, "&7Network Info", "", "&8\u21e8 &7Status: " + (complexity > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &r" + complexity));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, (ItemStack)new CustomItem(this.worldIcon, "&7" + SlimefunPlugin.getLocal().getMessage(p, "machines.GPS_CONTROL_PANEL.waypoints"), "", ChatColor.GRAY + "\u21e8 " + SlimefunPlugin.getLocal().getMessage(p, "guide.tooltips.open-category")));
        menu.addMenuClickHandler(6, (pl, slot, item, action) -> {
            this.openWaypointControlPanel(pl);
            return false;
        });
        int index = 0;
        for (Location l : this.getTransmitters(p.getUniqueId())) {
            if (index >= this.inventory.length) break;
            SlimefunItem sfi = BlockStorage.check(l);
            if (!(sfi instanceof GPSTransmitter)) continue;
            int slot3 = this.inventory[index];
            menu.addItem(slot3, (ItemStack)new CustomItem(SlimefunItems.GPS_TRANSMITTER, "&bGPS Transmitter", "&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "", "&8\u21e8 &7Signal Strength: &r" + ((GPSTransmitter)sfi).getMultiplier(l.getBlockY()), "&8\u21e8 &7Ping: &r" + DoubleHandler.fixDouble(1000.0 / l.getY()) + "ms"));
            menu.addMenuClickHandler(slot3, ChestMenuUtils.getEmptyClickHandler());
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public ItemStack getIcon(String name, World.Environment environment) {
        if (name.startsWith("player:death ")) {
            return this.deathpointIcon;
        }
        if (environment == World.Environment.NETHER) {
            return this.netherIcon;
        }
        if (environment == World.Environment.THE_END) {
            return this.endIcon;
        }
        return this.worldIcon;
    }

    public void openWaypointControlPanel(Player p) {
        ChestMenu menu = new ChestMenu(ChatColor.BLUE + SlimefunPlugin.getLocal().getMessage(p, "machines.GPS_CONTROL_PANEL.title"));
        for (int slot2 : this.border) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(2, (ItemStack)new CustomItem(SlimefunItems.GPS_TRANSMITTER, "&7" + SlimefunPlugin.getLocal().getMessage(p, "machines.GPS_CONTROL_PANEL.transmitters"), "", ChatColor.GRAY + "\u21e8 " + SlimefunPlugin.getLocal().getMessage(p, "guide.tooltips.open-category")));
        menu.addMenuClickHandler(2, (pl, slot, item, action) -> {
            this.openTransmitterControlPanel(pl);
            return false;
        });
        int complexity = this.getNetworkComplexity(p.getUniqueId());
        menu.addItem(4, (ItemStack)new CustomItem((ItemStack)SlimefunItems.GPS_CONTROL_PANEL, "&7Network Info", "", "&8\u21e8 &7Status: " + (complexity > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &r" + complexity));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, (ItemStack)new CustomItem(this.worldIcon, "&7" + SlimefunPlugin.getLocal().getMessage(p, "machines.GPS_CONTROL_PANEL.waypoints"), new String[0]));
        menu.addMenuClickHandler(6, ChestMenuUtils.getEmptyClickHandler());
        int index = 0;
        for (Map.Entry<String, Location> entry : this.getWaypoints(p.getUniqueId()).entrySet()) {
            if (index >= this.inventory.length) break;
            int slot3 = this.inventory[index];
            Location l = entry.getValue();
            ItemStack globe = this.getIcon(entry.getKey(), entry.getValue().getWorld().getEnvironment());
            menu.addItem(slot3, (ItemStack)new CustomItem(globe, entry.getKey().replace("player:death ", ""), "&8\u21e8 &7World: &r" + l.getWorld().getName(), "&8\u21e8 &7X: &r" + l.getX(), "&8\u21e8 &7Y: &r" + l.getY(), "&8\u21e8 &7Z: &r" + l.getZ(), "", "&8\u21e8 &cClick to delete"));
            menu.addMenuClickHandler(slot3, (pl, slotn, item, action) -> {
                String id = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)((String)entry.getKey()))).toUpperCase(Locale.ROOT).replace(' ', '_');
                Config cfg = new Config(WAYPOINTS_DIRECTORY + pl.getUniqueId().toString() + ".yml");
                cfg.setValue(id, null);
                cfg.save();
                pl.playSound(pl.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.openWaypointControlPanel(pl);
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    public Map<String, Location> getWaypoints(UUID uuid) {
        HashMap<String, Location> map = new HashMap<String, Location>();
        Config cfg = new Config(WAYPOINTS_DIRECTORY + uuid.toString() + ".yml");
        for (String key : cfg.getKeys()) {
            if (!cfg.contains(key + ".world") || Bukkit.getWorld((String)cfg.getString(key + ".world")) == null) continue;
            map.put(cfg.getString(key + ".name"), cfg.getLocation(key));
        }
        return map;
    }

    public void createWaypoint(Player p, Location l) {
        if (this.getWaypoints(p.getUniqueId()).size() + 2 > this.inventory.length) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.max", true);
            return;
        }
        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.new", true);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.0f);
        ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, p, message -> this.addWaypoint(p, (String)message, l));
    }

    public void addWaypoint(Player p, String name, Location l) {
        if (this.getWaypoints(p.getUniqueId()).size() + 2 > this.inventory.length) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.max", true);
            return;
        }
        WaypointCreateEvent event = new WaypointCreateEvent(p, name, l, name.startsWith("player:death "));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Config cfg = new Config(WAYPOINTS_DIRECTORY + p.getUniqueId().toString() + ".yml");
            String id = ChatColor.stripColor((String)ChatColors.color(name)).toUpperCase(Locale.ROOT).replace(' ', '_');
            cfg.setValue(id, l);
            cfg.setValue(id + ".name", name);
            cfg.save();
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.waypoint.added", true);
        }
    }

    public Set<Location> getTransmitters(UUID uuid) {
        return this.transmitters.getOrDefault(uuid, new HashSet());
    }

    public TeleportationManager getTeleportationManager() {
        return this.teleportation;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }
}

