/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.player;

import io.github.thebusybiscuit.slimefun4.api.items.HashedArmorpiece;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class PlayerProfile {
    private final UUID uuid;
    private final String name;
    private final Config cfg;
    private boolean dirty = false;
    private boolean markedForDeletion = false;
    private final Set<Research> researches = new HashSet<Research>();
    private final Map<Integer, PlayerBackpack> backpacks = new HashMap<Integer, PlayerBackpack>();
    private final GuideHistory guideHistory = new GuideHistory(this);
    private final HashedArmorpiece[] armor = new HashedArmorpiece[]{new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece()};

    private PlayerProfile(OfflinePlayer p) {
        this.uuid = p.getUniqueId();
        this.name = p.getName();
        this.cfg = new Config(new File("data-storage/Slimefun/Players/" + this.uuid.toString() + ".yml"));
        for (Research research : SlimefunPlugin.getRegistry().getResearches()) {
            if (!this.cfg.contains("researches." + research.getID())) continue;
            this.researches.add(research);
        }
    }

    public HashedArmorpiece[] getArmor() {
        return this.armor;
    }

    public Config getConfig() {
        return this.cfg;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        for (PlayerBackpack backpack : this.backpacks.values()) {
            backpack.save();
        }
        this.cfg.save();
        this.dirty = false;
    }

    public void setResearched(Research research, boolean unlock) {
        Validate.notNull((Object)research, (String)"Research must not be null!");
        this.dirty = true;
        if (unlock) {
            this.cfg.setValue("researches." + research.getID(), true);
            this.researches.add(research);
        } else {
            this.cfg.setValue("researches." + research.getID(), null);
            this.researches.remove(research);
        }
    }

    public boolean hasUnlocked(Research research) {
        if (research == null) {
            return true;
        }
        return !research.isEnabled() || this.researches.contains(research);
    }

    public Set<Research> getResearches() {
        return this.researches;
    }

    public void markForDeletion() {
        this.markedForDeletion = true;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public PlayerBackpack createBackpack(int size) {
        IntStream stream = IntStream.iterate(0, i -> i + 1).filter(i -> !this.cfg.contains("backpacks." + i + ".size"));
        int id = stream.findFirst().getAsInt();
        PlayerBackpack backpack = new PlayerBackpack(this, id, size);
        this.backpacks.put(id, backpack);
        return backpack;
    }

    public Optional<PlayerBackpack> getBackpack(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Backpacks cannot have negative ids!");
        }
        PlayerBackpack backpack = this.backpacks.get(id);
        if (backpack != null) {
            return Optional.of(backpack);
        }
        if (this.cfg.contains("backpacks." + id + ".size")) {
            backpack = new PlayerBackpack(this, id);
            this.backpacks.put(id, backpack);
            return Optional.of(backpack);
        }
        return Optional.empty();
    }

    public String getTitle() {
        List<String> titles = SlimefunPlugin.getRegistry().getResearchRanks();
        float fraction = (float)this.researches.size() / (float)SlimefunPlugin.getRegistry().getResearches().size();
        int index = (int)(fraction * (float)(titles.size() - 1));
        return titles.get(index);
    }

    public void sendStats(CommandSender sender) {
        Set<Research> researched = this.getResearches();
        int levels = researched.stream().mapToInt(Research::getCost).sum();
        int totalResearches = SlimefunPlugin.getRegistry().getResearches().size();
        float progress = (float)Math.round((float)researched.size() * 100.0f / (float)totalResearches * 100.0f) / 100.0f;
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&7Statistics for Player: &b" + this.name));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&7Title: " + ChatColor.AQUA + this.getTitle()));
        sender.sendMessage(ChatColors.color("&7Research Progress: " + NumberUtils.getColorFromPercentage(progress) + progress + " &r% " + ChatColor.YELLOW + '(' + researched.size() + " / " + totalResearches + ')'));
        sender.sendMessage(ChatColors.color("&7Total XP Levels spent: " + ChatColor.AQUA + levels));
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getUUID());
    }

    public GuideHistory getGuideHistory() {
        return this.guideHistory;
    }

    public static boolean fromUUID(UUID uuid, Consumer<PlayerProfile> callback) {
        return PlayerProfile.get(Bukkit.getOfflinePlayer((UUID)uuid), callback);
    }

    public static boolean get(OfflinePlayer p, Consumer<PlayerProfile> callback) {
        Validate.notNull((Object)p, (String)"Cannot get a PlayerProfile for: null!");
        UUID uuid = p.getUniqueId();
        PlayerProfile profile = (PlayerProfile)SlimefunPlugin.getRegistry().getPlayerProfiles().get(uuid);
        if (profile != null) {
            callback.accept(profile);
            return true;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SlimefunPlugin.instance, () -> {
            PlayerProfile pp = new PlayerProfile(p);
            SlimefunPlugin.getRegistry().getPlayerProfiles().put(uuid, pp);
            callback.accept(pp);
        });
        return false;
    }

    public static boolean request(OfflinePlayer p) {
        if (!SlimefunPlugin.getRegistry().getPlayerProfiles().containsKey(p.getUniqueId())) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)SlimefunPlugin.instance, () -> {
                PlayerProfile pp = new PlayerProfile(p);
                SlimefunPlugin.getRegistry().getPlayerProfiles().put(p.getUniqueId(), pp);
            });
            return false;
        }
        return true;
    }

    public static Optional<PlayerProfile> find(OfflinePlayer p) {
        return Optional.ofNullable(SlimefunPlugin.getRegistry().getPlayerProfiles().get(p.getUniqueId()));
    }

    public static Iterator<PlayerProfile> iterator() {
        return SlimefunPlugin.getRegistry().getPlayerProfiles().values().iterator();
    }

    public static void getBackpack(ItemStack item, Consumer<PlayerBackpack> callback) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return;
        }
        OptionalInt id = OptionalInt.empty();
        String uuid = "";
        for (String line : item.getItemMeta().getLore()) {
            String[] splitLine;
            if (!line.startsWith(ChatColors.color("&7ID: ")) || line.indexOf(35) == -1 || !PatternUtils.NUMERIC.matcher((splitLine = PatternUtils.HASH.split(line))[1]).matches()) continue;
            id = OptionalInt.of(Integer.parseInt(splitLine[1]));
            uuid = splitLine[0].replace(ChatColors.color("&7ID: "), "");
        }
        if (id.isPresent()) {
            int number = id.getAsInt();
            PlayerProfile.fromUUID(UUID.fromString(uuid), profile -> {
                Optional<PlayerBackpack> backpack = profile.getBackpack(number);
                if (backpack.isPresent()) {
                    callback.accept(backpack.get());
                }
            });
        }
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PlayerProfile && this.uuid.equals(((PlayerProfile)obj).uuid);
    }

    public String toString() {
        return "PlayerProfile {" + this.uuid + "}";
    }
}

