/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import java.util.Optional;
import java.util.logging.Logger;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ItemState;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class Slimefun {
    private Slimefun() {
    }

    public static Logger getLogger() {
        return SlimefunPlugin.instance.getLogger();
    }

    @Deprecated
    public static void registerResearch(Research research, ItemStack ... items) {
        for (ItemStack item : items) {
            research.addItems(SlimefunItem.getByItem(item));
        }
        research.register();
    }

    @Deprecated
    public static void registerResearch(NamespacedKey key, int id, String name, int cost, ItemStack ... items) {
        Slimefun.registerResearch(new Research(key, id, name, cost), items);
    }

    public static boolean hasUnlocked(Player p, ItemStack item, boolean message) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem != null) {
            return Slimefun.hasUnlocked(p, sfItem, message);
        }
        return true;
    }

    public static boolean hasUnlocked(Player p, SlimefunItem sfItem, boolean message) {
        if (sfItem.getState() == ItemState.VANILLA_FALLBACK) {
            return true;
        }
        if (Slimefun.isEnabled(p, sfItem, message) && Slimefun.hasPermission(p, sfItem, message)) {
            if (sfItem.getResearch() == null) {
                return true;
            }
            Optional<PlayerProfile> profile = PlayerProfile.find((OfflinePlayer)p);
            if (!profile.isPresent()) {
                PlayerProfile.request((OfflinePlayer)p);
                return false;
            }
            if (profile.get().hasUnlocked(sfItem.getResearch())) {
                return true;
            }
            if (message && !(sfItem instanceof VanillaItem)) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.not-researched", true);
            }
            return false;
        }
        return false;
    }

    public static boolean hasPermission(Player p, SlimefunItem item, boolean message) {
        if (item == null) {
            return true;
        }
        if (SlimefunPlugin.getPermissionsService().hasPermission((Permissible)p, item)) {
            return true;
        }
        if (message) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.no-permission", true);
        }
        return false;
    }

    public static boolean isEnabled(Player p, ItemStack item, boolean message) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        return sfItem == null || Slimefun.isEnabled(p, sfItem, message);
    }

    public static boolean isEnabled(Player p, SlimefunItem sfItem, boolean message) {
        if (sfItem.isDisabled()) {
            if (message) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.disabled-item", true);
            }
            return false;
        }
        if (!SlimefunPlugin.getWorldSettingsService().isEnabled(p.getWorld(), sfItem)) {
            if (message) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.disabled-in-world", true);
            }
            return false;
        }
        return true;
    }

    public static BukkitTask runSync(Runnable r) {
        return Bukkit.getScheduler().runTask((Plugin)SlimefunPlugin.instance, r);
    }

    public static BukkitTask runSync(Runnable r, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)SlimefunPlugin.instance, r, delay);
    }
}

