/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AbstractEnergyGenerator;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AGenerator
extends AbstractEnergyGenerator {
    public static Map<Location, MachineFuel> processing = new HashMap<Location, MachineFuel>();
    public static Map<Location, Integer> progress = new HashMap<Location, Integer>();
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] border_in = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] border_out = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};

    public AGenerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.id, this.getInventoryTitle()){

            @Override
            public void init() {
                AGenerator.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return AGenerator.this.getInputSlots();
                }
                return AGenerator.this.getOutputSlots();
            }
        };
        AGenerator.registerBlockHandler(this.id, (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                for (int slot : this.getInputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
                for (int slot : this.getOutputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
            }
            progress.remove(b.getLocation());
            processing.remove(b.getLocation());
            return true;
        });
        this.registerDefaultFuelTypes();
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_in) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_out) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    public MachineFuel getProcessing(Location l) {
        return processing.get(l);
    }

    public boolean isProcessing(Location l) {
        return progress.containsKey(l);
    }

    @Override
    protected GeneratorTicker onTick() {
        return new GeneratorTicker(){

            @Override
            public double generateEnergy(Location l, SlimefunItem sf, Config data) {
                int charge;
                BlockMenu inv = BlockStorage.getInventory(l);
                boolean chargeable = ChargableBlock.isChargable(l);
                int n = charge = chargeable ? ChargableBlock.getCharge(l) : 0;
                if (AGenerator.this.isProcessing(l)) {
                    int timeleft = progress.get(l);
                    if (timeleft > 0) {
                        ChestMenuUtils.updateProgressbar(inv, 22, timeleft, processing.get(l).getTicks(), AGenerator.this.getProgressBar());
                        if (chargeable) {
                            if (ChargableBlock.getMaxCharge(l) - charge >= AGenerator.this.getEnergyProduction()) {
                                ChargableBlock.addCharge(l, AGenerator.this.getEnergyProduction());
                                progress.put(l, timeleft - 1);
                                return charge + AGenerator.this.getEnergyProduction();
                            }
                            return charge;
                        }
                        progress.put(l, timeleft - 1);
                        return AGenerator.this.getEnergyProduction();
                    }
                    ItemStack fuel = processing.get(l).getInput();
                    if (SlimefunUtils.isItemSimilar(fuel, new ItemStack(Material.LAVA_BUCKET), true) || SlimefunUtils.isItemSimilar(fuel, SlimefunItems.BUCKET_OF_FUEL, true) || SlimefunUtils.isItemSimilar(fuel, SlimefunItems.BUCKET_OF_OIL, true)) {
                        inv.pushItem(new ItemStack(Material.BUCKET), AGenerator.this.getOutputSlots());
                    }
                    inv.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                    progress.remove(l);
                    processing.remove(l);
                    return charge;
                }
                HashMap found = new HashMap();
                MachineFuel fuel = AGenerator.this.findRecipe(inv, found);
                if (fuel != null) {
                    for (Map.Entry entry : found.entrySet()) {
                        inv.consumeItem((Integer)entry.getKey(), (Integer)entry.getValue());
                    }
                    processing.put(l, fuel);
                    progress.put(l, fuel.getTicks());
                }
                return charge;
            }

            @Override
            public boolean explode(Location l) {
                return false;
            }
        };
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel recipe : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), recipe.getInput(), true)) continue;
                found.put(slot, recipe.getInput().getAmount());
                return recipe;
            }
        }
        return null;
    }
}

