/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.HandledBlock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ExplosivePickaxe
extends SimpleSlimefunItem<BlockBreakHandler>
implements NotPlaceable,
DamageableItem {
    private final ItemSetting<Boolean> damageOnUse = new ItemSetting<Boolean>("damage-on-use", true);

    public ExplosivePickaxe(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.damageOnUse);
    }

    @Override
    public BlockBreakHandler getItemHandler() {
        return new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (ExplosivePickaxe.this.isItem(item)) {
                    if (Slimefun.hasUnlocked(e.getPlayer(), ExplosivePickaxe.this, true)) {
                        e.getBlock().getWorld().createExplosion(e.getBlock().getLocation(), 0.0f);
                        e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    if (x == 0 && y == 0 && z == 0) continue;
                                    Block b = e.getBlock().getRelative(x, y, z);
                                    ExplosivePickaxe.this.breakBlock(e.getPlayer(), item, b, fortune, drops);
                                }
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private void breakBlock(Player p, ItemStack item, Block b, int fortune, List<ItemStack> drops) {
        if (b.getType() != Material.AIR && !b.isLiquid() && !MaterialCollections.getAllUnbreakableBlocks().contains(b.getType()) && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.BREAK_BLOCK)) {
            SlimefunPlugin.getProtectionManager().logAction((OfflinePlayer)p, b, ProtectableAction.BREAK_BLOCK);
            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
            SlimefunItem sfItem = BlockStorage.check(b);
            if (sfItem != null && !(sfItem instanceof HandledBlock)) {
                SlimefunBlockHandler handler = SlimefunPlugin.getRegistry().getBlockHandlers().get(sfItem.getID());
                if (handler != null && !handler.onBreak(p, b, sfItem, UnregisterReason.PLAYER_BREAK)) {
                    drops.add(BlockStorage.retrieve(b));
                }
            } else if (b.getType() == Material.PLAYER_HEAD || b.getType().name().endsWith("_SHULKER_BOX")) {
                b.breakNaturally();
            } else {
                for (ItemStack drop : b.getDrops(this.getItem())) {
                    b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)(b.getType().toString().endsWith("_ORE") && b.getType() != Material.IRON_ORE && b.getType() != Material.GOLD_ORE ? new CustomItem(drop, fortune) : drop));
                }
                b.setType(Material.AIR);
            }
            this.damageItem(p, item);
        }
    }

    @Override
    public boolean isDamageable() {
        return this.damageOnUse.getValue();
    }
}

