/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.attributes.WitherProof;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideLayout;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.guide.BookSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.guide.CheatSheetSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.guide.ChestSlimefunGuide;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockInfoConfig;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.KeyMap;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class SlimefunRegistry {
    private final Map<String, SlimefunItem> slimefunIds = new HashMap<String, SlimefunItem>();
    private final List<SlimefunItem> slimefunItems = new ArrayList<SlimefunItem>();
    private final List<SlimefunItem> enabledItems = new ArrayList<SlimefunItem>();
    private final List<Category> categories = new ArrayList<Category>();
    private final List<MultiBlock> multiblocks = new LinkedList<MultiBlock>();
    private final List<Research> researches = new LinkedList<Research>();
    private final List<String> researchRanks = new ArrayList<String>();
    private final Set<UUID> researchingPlayers = new HashSet<UUID>();
    private boolean automaticallyLoadItems;
    private boolean enableResearches;
    private boolean freeCreativeResearches;
    private boolean researchFireworks;
    private final Set<String> tickers = new HashSet<String>();
    private final Set<SlimefunItem> radioactive = new HashSet<SlimefunItem>();
    private final Set<String> activeChunks = new HashSet<String>();
    private final KeyMap<GEOResource> geoResources = new KeyMap();
    private final Set<String> energyGenerators = new HashSet<String>();
    private final Set<String> energyCapacitors = new HashSet<String>();
    private final Set<String> energyConsumers = new HashSet<String>();
    private final Set<String> chargeableBlocks = new HashSet<String>();
    private final Map<String, WitherProof> witherProofBlocks = new HashMap<String, WitherProof>();
    private final ConcurrentMap<UUID, PlayerProfile> profiles = new ConcurrentHashMap<UUID, PlayerProfile>();
    private final Map<String, BlockStorage> worlds = new HashMap<String, BlockStorage>();
    private final Map<String, BlockInfoConfig> chunks = new HashMap<String, BlockInfoConfig>();
    private final Map<SlimefunGuideLayout, SlimefunGuideImplementation> layouts = new EnumMap<SlimefunGuideLayout, SlimefunGuideImplementation>(SlimefunGuideLayout.class);
    private final Map<EntityType, Set<ItemStack>> drops = new EnumMap<EntityType, Set<ItemStack>>(EntityType.class);
    private final Map<String, Integer> capacities = new HashMap<String, Integer>();
    private final Map<String, BlockMenuPreset> blockMenuPresets = new HashMap<String, BlockMenuPreset>();
    private final Map<String, UniversalBlockMenu> universalInventories = new HashMap<String, UniversalBlockMenu>();
    private final Map<Class<? extends ItemHandler>, Set<ItemHandler>> itemHandlers = new HashMap<Class<? extends ItemHandler>, Set<ItemHandler>>();
    private final Map<String, SlimefunBlockHandler> blockHandlers = new HashMap<String, SlimefunBlockHandler>();
    private final Map<String, Set<Location>> activeTickers = new HashMap<String, Set<Location>>();
    private final Map<String, ItemStack> automatedCraftingChamberRecipes = new HashMap<String, ItemStack>();

    public void load(Config cfg) {
        boolean showVanillaRecipes = cfg.getBoolean("guide.show-vanilla-recipes");
        this.layouts.put(SlimefunGuideLayout.CHEST, new ChestSlimefunGuide(showVanillaRecipes));
        this.layouts.put(SlimefunGuideLayout.CHEAT_SHEET, new CheatSheetSlimefunGuide());
        this.layouts.put(SlimefunGuideLayout.BOOK, new BookSlimefunGuide());
        this.researchRanks.addAll(cfg.getStringList("research-ranks"));
        this.freeCreativeResearches = cfg.getBoolean("researches.free-in-creative-mode");
        this.researchFireworks = cfg.getBoolean("researches.enable-fireworks");
    }

    public boolean isAutoLoadingEnabled() {
        return this.automaticallyLoadItems;
    }

    public void setAutoLoadingMode(boolean mode) {
        this.automaticallyLoadItems = mode;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<SlimefunItem> getAllSlimefunItems() {
        return this.slimefunItems;
    }

    public List<SlimefunItem> getEnabledSlimefunItems() {
        return this.enabledItems;
    }

    public List<Research> getResearches() {
        return this.researches;
    }

    public Set<UUID> getCurrentlyResearchingPlayers() {
        return this.researchingPlayers;
    }

    public List<String> getResearchRanks() {
        return this.researchRanks;
    }

    public void setResearchingEnabled(boolean enabled) {
        this.enableResearches = enabled;
    }

    public boolean isResearchingEnabled() {
        return this.enableResearches;
    }

    public void setFreeCreativeResearchingEnabled(boolean enabled) {
        this.freeCreativeResearches = enabled;
    }

    public boolean isFreeCreativeResearchingEnabled() {
        return this.freeCreativeResearches;
    }

    public boolean isResearchFireworkEnabled() {
        return this.researchFireworks;
    }

    public List<MultiBlock> getMultiBlocks() {
        return this.multiblocks;
    }

    public SlimefunGuideImplementation getGuideLayout(SlimefunGuideLayout layout) {
        return this.layouts.get((Object)layout);
    }

    public Map<EntityType, Set<ItemStack>> getMobDrops() {
        return this.drops;
    }

    public Set<ItemStack> getMobDrops(EntityType entity) {
        return this.drops.get(entity);
    }

    public Set<SlimefunItem> getRadioactiveItems() {
        return this.radioactive;
    }

    public Set<String> getTickerBlocks() {
        return this.tickers;
    }

    public Set<String> getActiveChunks() {
        return this.activeChunks;
    }

    public Map<String, SlimefunItem> getSlimefunItemIds() {
        return this.slimefunIds;
    }

    public Map<String, Integer> getEnergyCapacities() {
        return this.capacities;
    }

    public Map<String, BlockMenuPreset> getMenuPresets() {
        return this.blockMenuPresets;
    }

    public Map<String, UniversalBlockMenu> getUniversalInventories() {
        return this.universalInventories;
    }

    public ConcurrentMap<UUID, PlayerProfile> getPlayerProfiles() {
        return this.profiles;
    }

    public Map<Class<? extends ItemHandler>, Set<ItemHandler>> getPublicItemHandlers() {
        return this.itemHandlers;
    }

    public Map<String, SlimefunBlockHandler> getBlockHandlers() {
        return this.blockHandlers;
    }

    public Map<String, BlockStorage> getWorlds() {
        return this.worlds;
    }

    public Map<String, BlockInfoConfig> getChunks() {
        return this.chunks;
    }

    public Map<String, Set<Location>> getActiveTickers() {
        return this.activeTickers;
    }

    public KeyMap<GEOResource> getGEOResources() {
        return this.geoResources;
    }

    @Deprecated
    public Map<String, ItemStack> getAutomatedCraftingChamberRecipes() {
        return this.automatedCraftingChamberRecipes;
    }

    public Set<String> getEnergyGenerators() {
        return this.energyGenerators;
    }

    public Set<String> getEnergyCapacitors() {
        return this.energyCapacitors;
    }

    public Set<String> getEnergyConsumers() {
        return this.energyConsumers;
    }

    public Set<String> getChargeableBlocks() {
        return this.chargeableBlocks;
    }

    public Map<String, WitherProof> getWitherProofBlocks() {
        return this.witherProofBlocks;
    }
}

