/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.players.MinecraftAccount;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

class GitHubTask
implements Runnable {
    private static final int MAX_REQUESTS_PER_MINUTE = 12;
    private final GitHubService gitHubService;

    GitHubTask(GitHubService github) {
        this.gitHubService = github;
    }

    @Override
    public void run() {
        this.gitHubService.getConnectors().forEach(GitHubConnector::pullFile);
        this.grabTextures();
    }

    private void grabTextures() {
        HashMap<String, String> skins = new HashMap<String, String>();
        int count = 0;
        for (Contributor contributor : this.gitHubService.getContributors().values()) {
            if (contributor.hasTexture()) continue;
            try {
                if (skins.containsKey(contributor.getMinecraftName())) {
                    contributor.setTexture((String)skins.get(contributor.getMinecraftName()));
                    continue;
                }
                contributor.setTexture(this.grabTexture(skins, contributor.getMinecraftName()));
                if (++count < 12) continue;
                break;
            }
            catch (IllegalArgumentException x) {
                contributor.setTexture(null);
            }
            catch (IOException x) {
                Slimefun.getLogger().log(Level.WARNING, "Attempted to connect to mojang.com, got this response: {0}: {1}", new Object[]{x.getClass().getSimpleName(), x.getMessage()});
                Slimefun.getLogger().log(Level.WARNING, "This usually means mojang.com is down or started to rate-limit this connection, this is not an error message!");
                if (x.getMessage().contains("429")) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SlimefunPlugin.instance, this::grabTextures, 2400L);
                }
                return;
            }
            catch (MinecraftAccount.TooManyRequestsException x) {
                Slimefun.getLogger().log(Level.WARNING, "Received a rate-limit from mojang.com, retrying in 2 minutes");
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SlimefunPlugin.instance, this::grabTextures, 2400L);
                return;
            }
        }
        if (count >= 12) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SlimefunPlugin.instance, this::grabTextures, 1200L);
        }
    }

    private String grabTexture(Map<String, String> skins, String username) throws MinecraftAccount.TooManyRequestsException, IOException {
        Optional<UUID> uuid = MinecraftAccount.getUUID(username);
        if (uuid.isPresent()) {
            Optional<String> skin = MinecraftAccount.getSkin(uuid.get());
            skins.put(username, skin.orElse(""));
            return skin.orElse(null);
        }
        return null;
    }
}

