/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PermissionsService {
    private final Map<String, String> permissions = new HashMap<String, String>();
    private final Config config;

    public PermissionsService(SlimefunPlugin plugin) {
        this.config = new Config((Plugin)plugin, "permissions.yml");
        this.config.getConfiguration().options().header("This file is used to assign permission nodes to items from Slimefun or any of its addons.\nTo assign an item a certain permission node you simply have to set the 'permission' attribute\nto your desired permission node. You can also customize the text that is displayed when a Player does not have that permission.");
        this.config.getConfiguration().options().copyHeader(true);
    }

    public void register(Iterable<SlimefunItem> items, boolean save) {
        for (SlimefunItem item : items) {
            if (item == null || item.getID() == null || this.migrate(item)) continue;
            this.config.setDefaultValue(item.getID() + ".permission", "none");
            this.config.setDefaultValue(item.getID() + ".lore", new String[]{"&rYou do not have the permission", "&rto access this item."});
            this.permissions.put(item.getID(), this.config.getString(item.getID() + ".permission"));
        }
        if (save) {
            this.config.save();
        }
    }

    private boolean migrate(SlimefunItem item) {
        String permission = SlimefunPlugin.getItemCfg().getString(item.getID() + ".required-permission");
        if (permission != null) {
            this.config.setDefaultValue(item.getID() + ".permission", permission.length() == 0 ? "none" : permission);
            this.config.setDefaultValue(item.getID() + ".lore", SlimefunPlugin.getItemCfg().getString(item.getID() + ".no-permission-tooltip"));
            this.permissions.put(item.getID(), this.config.getString(item.getID() + ".permission"));
            SlimefunPlugin.getItemCfg().setValue(item.getID() + ".required-permission", null);
            SlimefunPlugin.getItemCfg().setValue(item.getID() + ".no-permission-tooltip", null);
            return true;
        }
        return false;
    }

    public boolean hasPermission(Permissible p, SlimefunItem item) {
        if (item == null) {
            return true;
        }
        String permission = this.permissions.get(item.getID());
        return permission == null || permission.equals("none") || p.hasPermission(permission);
    }

    public void setPermission(SlimefunItem item, String permission) {
        this.permissions.put(item.getID(), permission != null ? permission : "none");
    }

    public void save() {
        for (Map.Entry<String, String> entry : this.permissions.entrySet()) {
            this.config.setValue(entry.getKey() + ".permission", entry.getValue());
        }
        this.config.save();
    }

    public List<String> getLore(SlimefunItem item) {
        List<String> lore = this.config.getStringList(item.getID() + ".lore");
        return lore == null ? Arrays.asList("LORE NOT FOUND") : lore;
    }
}

