/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.implementation.items.food.Cooler;
import io.github.thebusybiscuit.slimefun4.implementation.items.food.Juice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BackpackListener
implements Listener {
    private Map<UUID, ItemStack> backpacks = new HashMap<UUID, ItemStack>();

    public void register(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        ItemStack backpack = this.backpacks.remove(p.getUniqueId());
        if (backpack != null) {
            p.playSound(p.getLocation(), Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f);
            PlayerProfile.getBackpack(backpack, PlayerBackpack::markDirty);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        ItemStack item;
        SlimefunItem sfItem;
        if (this.backpacks.containsKey(e.getPlayer().getUniqueId()) && (sfItem = SlimefunItem.getByItem(item = e.getItemDrop().getItemStack())) instanceof SlimefunBackpack) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent e) {
        ItemStack item = this.backpacks.get(e.getWhoClicked().getUniqueId());
        if (item != null) {
            SlimefunItem backpack = SlimefunItem.getByItem(item);
            if (e.getClick() == ClickType.NUMBER_KEY) {
                ItemStack hotbarItem;
                if (e.getClickedInventory().getType() != InventoryType.PLAYER && !this.isItemAllowed(hotbarItem = e.getWhoClicked().getInventory().getItem(e.getHotbarButton()), backpack)) {
                    e.setCancelled(true);
                }
            } else if (!this.isItemAllowed(e.getCurrentItem(), backpack)) {
                e.setCancelled(true);
            }
        }
    }

    private boolean isItemAllowed(ItemStack item, SlimefunItem backpack) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        if (item.getType() == Material.SHULKER_BOX || item.getType().toString().endsWith("_SHULKER_BOX")) {
            return false;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem(item);
        if (slimefunItem instanceof SlimefunBackpack) {
            return false;
        }
        if (backpack instanceof Cooler) {
            return slimefunItem instanceof Juice;
        }
        return true;
    }

    public void openBackpack(Player p, ItemStack item, SlimefunBackpack backpack) {
        if (item.getAmount() == 1) {
            if (Slimefun.hasUnlocked(p, backpack, true) && !PlayerProfile.get((OfflinePlayer)p, profile -> this.openBackpack(p, item, (PlayerProfile)profile, backpack.getSize()))) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.opening-backpack");
            }
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "backpack.no-stack", true);
        }
    }

    private void openBackpack(Player p, ItemStack item, PlayerProfile profile, int size) {
        List lore = item.getItemMeta().getLore();
        for (int line = 0; line < lore.size(); ++line) {
            if (!((String)lore.get(line)).equals(ChatColors.color("&7ID: <ID>"))) continue;
            this.setBackpackId(p, item, line, profile.createBackpack(size).getId());
            break;
        }
        if (!this.backpacks.containsValue(item)) {
            p.playSound(p.getLocation(), Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f);
            this.backpacks.put(p.getUniqueId(), item);
            PlayerProfile.getBackpack(item, backpack -> {
                if (backpack != null) {
                    backpack.open(p);
                }
            });
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "backpack.already-open", true);
        }
    }

    public void setBackpackId(Player p, ItemStack item, int line, int id) {
        ItemMeta im = item.getItemMeta();
        List lore = im.getLore();
        lore.set(line, ((String)lore.get(line)).replace("<ID>", p.getUniqueId() + "#" + id));
        im.setLore(lore);
        item.setItemMeta(im);
    }
}

