/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.chat.json;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ChatComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.CustomBookListener;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CustomBookInterface {
    private static CustomBookListener listener;
    private static Field pagesField;
    private static Method playerHandle;
    private static Method openBook;
    private static Method copyBook;
    private static Object mainHand;
    private final Plugin plugin;
    private String author;
    private String title = "Book";
    private final List<ChatComponent> pages = new LinkedList<ChatComponent>();
    private final Map<NamespacedKey, Consumer<Player>> clickables = new HashMap<NamespacedKey, Consumer<Player>>();

    public CustomBookInterface(@NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (listener == null) {
            listener = new CustomBookListener(plugin);
        }
        this.plugin = plugin;
        this.author = plugin.getName();
    }

    public void addPage(@NonNull ChatComponent page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        this.pages.add(page);
        this.clickables.putAll(page.getClickables());
    }

    public ItemStack getItem() {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(this.title);
        meta.setAuthor(this.author);
        List field = null;
        try {
            field = (List)pagesField.get(meta);
            for (ChatComponent page : this.pages) {
                field.add(page.getAsNMSComponent());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not access pages of a book", e);
        }
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public void open(@NonNull Player p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (listener.getPlayers().contains(p.getUniqueId())) {
            return;
        }
        ItemStack book = this.getItem();
        listener.getBooks().put(p.getUniqueId(), this);
        if (!ReflectionUtils.isVersion("v1_13_")) {
            p.openBook(book);
        } else {
            int slot = p.getInventory().getHeldItemSlot();
            ItemStack item = p.getInventory().getItem(slot);
            listener.getPlayers().add(p.getUniqueId());
            p.getInventory().setItem(slot, book);
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
                try {
                    Object copy = copyBook.invoke(null, book);
                    openBook.invoke(playerHandle.invoke((Object)p, new Object[0]), copy, mainHand);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not open a Written Book", e);
                }
                p.getInventory().setItem(slot, item);
                listener.getPlayers().remove(p.getUniqueId());
            }, 1L);
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ChatComponent> getPages() {
        return this.pages;
    }

    public Map<NamespacedKey, Consumer<Player>> getClickables() {
        return this.clickables;
    }

    static {
        try {
            Class<?> metaClass = ReflectionUtils.getOBCClass("inventory.CraftMetaBook");
            pagesField = ReflectionUtils.getField(metaClass, "pages");
            pagesField.setAccessible(true);
            copyBook = ReflectionUtils.getMethod(ReflectionUtils.getOBCClass("inventory.CraftItemStack"), "asNMSCopy", ItemStack.class);
            Class<?> enumhand = ReflectionUtils.getNMSClass("EnumHand");
            playerHandle = ReflectionUtils.getOBCClass("entity.CraftPlayer").getMethod("getHandle", new Class[0]);
            openBook = ReflectionUtils.getMethod(ReflectionUtils.getNMSClass("EntityPlayer"), "openBook", ReflectionUtils.getNMSClass("ItemStack"), enumhand);
            mainHand = ReflectionUtils.getEnumConstant(enumhand, "MAIN_HAND");
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            System.err.println("Perhaps you forgot to shade CS-CoreLib's \"reflection\" package?");
            e.printStackTrace();
        }
    }
}

