/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.item_transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.CargoManager;
import me.mrCookieSlime.Slimefun.api.item_transport.ChestTerminalSorter;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemRequest;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemSlot;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.StoredItem;
import me.mrCookieSlime.Slimefun.api.network.Network;
import me.mrCookieSlime.Slimefun.holograms.CargoHologram;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class CargoNet
extends Network {
    public static boolean EXTRA_CHANNELS = false;
    private static final int RANGE = 5;
    public static List<BlockFace> faces = Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    public static Map<Location, Integer> round_robin = new HashMap<Location, Integer>();
    public static Set<ItemRequest> requests = new HashSet<ItemRequest>();
    private static int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private static final ChestTerminalSorter sorter = new ChestTerminalSorter();
    public static final int[] terminal_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
    private static final ItemStack terminal_noitem_item = new CustomItem(new MaterialData(Material.BARRIER), "&4No Item cached", new String[0]);
    private static final ChestMenu.MenuClickHandler terminal_noitem_handler = new ChestMenu.MenuClickHandler(){

        public boolean onClick(Player p, int slot, ItemStack stack, ClickAction action) {
            return false;
        }
    };
    private Set<Location> inputNodes = new HashSet<Location>();
    private Set<Location> outputNodes = new HashSet<Location>();
    private Set<Location> advancedOutputNodes = new HashSet<Location>();
    final Set<Location> terminals = new HashSet<Location>();
    final Set<Location> imports = new HashSet<Location>();
    final Set<Location> exports = new HashSet<Location>();

    public static CargoNet getNetworkFromLocation(Location l) {
        return CargoNet.getNetworkFromLocation(l, CargoNet.class);
    }

    public static CargoNet getNetworkFromLocationOrCreate(Location l) {
        CargoNet cargo_network = CargoNet.getNetworkFromLocation(l);
        if (cargo_network == null) {
            cargo_network = new CargoNet(l);
            CargoNet.registerNetwork(cargo_network);
        }
        return cargo_network;
    }

    @Deprecated
    public static boolean isConnected(Block b) {
        return CargoNet.getNetworkFromLocation(b.getLocation()) != null;
    }

    protected CargoNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public Network.Component classifyLocation(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        switch (id) {
            case "CARGO_MANAGER": {
                return Network.Component.REGULATOR;
            }
            case "CARGO_NODE": {
                return Network.Component.CONNECTOR;
            }
            case "CARGO_NODE_INPUT": 
            case "CARGO_NODE_OUTPUT": 
            case "CARGO_NODE_OUTPUT_ADVANCED": 
            case "CT_IMPORT_BUS": 
            case "CT_EXPORT_BUS": 
            case "CHEST_TERMINAL": {
                return Network.Component.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void locationClassificationChange(Location l, Network.Component from, Network.Component to) {
        if (from == Network.Component.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
            this.advancedOutputNodes.remove(l);
            this.terminals.remove(l);
            this.imports.remove(l);
            this.exports.remove(l);
        }
        if (to == Network.Component.TERMINUS) {
            switch (BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": {
                    this.outputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.advancedOutputNodes.add(l);
                    break;
                }
                case "CHEST_TERMINAL": {
                    this.terminals.add(l);
                    break;
                }
                case "CT_IMPORT_BUS": {
                    this.imports.add(l);
                    break;
                }
                case "CT_EXPORT_BUS": {
                    this.exports.add(l);
                }
            }
        }
    }

    public void tick(final Block b) {
        Object frequency;
        if (!this.regulator.equals((Object)b.getLocation())) {
            CargoHologram.update(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            CargoHologram.update(b, "&7Status: &4&lOFFLINE");
            return;
        }
        CargoHologram.update(b, "&7Status: &a&lONLINE");
        final HashMap output = new HashMap();
        for (Location outputNode : this.outputNodes) {
            frequency = CargoNet.getFrequency(outputNode);
            if (!output.containsKey(frequency)) {
                output.put((Integer)frequency, new ArrayList());
            }
            ((List)output.get(frequency)).add(outputNode);
        }
        for (Location outputNode : this.advancedOutputNodes) {
            frequency = CargoNet.getFrequency(outputNode);
            if (!output.containsKey(frequency)) {
                output.put((Integer)frequency, new ArrayList());
            }
            ((List)output.get(frequency)).add(outputNode);
        }
        final HashSet<Location> providers = new HashSet<Location>();
        final HashSet destinations = output.containsKey(16) ? new HashSet((Collection)output.get(16)) : new HashSet();
        for (Location inputNode : this.inputNodes) {
            int frequency2 = CargoNet.getFrequency(inputNode);
            if (frequency2 != 16) continue;
            providers.add(inputNode);
        }
        final CargoNet self = this;
        final BlockStorage storage = BlockStorage.getStorage(b.getWorld());
        SlimefunStartup.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

            @Override
            public void run() {
                if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
                    self.display();
                }
                if (EXTRA_CHANNELS) {
                    Block target;
                    BlockMenu menu;
                    for (Location bus : CargoNet.this.imports) {
                        menu = BlockStorage.getInventory(bus);
                        if (menu.getItemInSlot(17) == null) {
                            target = CargoNet.getAttachedBlock(bus.getBlock());
                            ItemSlot stack = CargoManager.withdraw(bus.getBlock(), storage, target, -1);
                            if (stack != null) {
                                menu.replaceExistingItem(17, stack.getItem());
                            }
                        }
                        if (menu.getItemInSlot(17) == null) continue;
                        requests.add(new ItemRequest(bus, 17, menu.getItemInSlot(17), ItemTransportFlow.INSERT));
                    }
                    for (Location bus : CargoNet.this.exports) {
                        menu = BlockStorage.getInventory(bus);
                        if (menu.getItemInSlot(17) != null) {
                            target = CargoNet.getAttachedBlock(bus.getBlock());
                            menu.replaceExistingItem(17, CargoManager.insert(bus.getBlock(), storage, target, menu.getItemInSlot(17), -1));
                        }
                        if (menu.getItemInSlot(17) != null) continue;
                        ArrayList<CustomItem> items = new ArrayList<CustomItem>();
                        for (int slot : slots) {
                            ItemStack template = menu.getItemInSlot(slot);
                            if (template == null) continue;
                            items.add(new CustomItem(template, 1));
                        }
                        if (items.isEmpty()) continue;
                        int index = Integer.parseInt(BlockStorage.getLocationInfo(bus, "index"));
                        if (++index > items.size() - 1) {
                            index = 0;
                        }
                        BlockStorage.addBlockInfo(bus, "index", String.valueOf(index));
                        requests.add(new ItemRequest(bus, 17, (ItemStack)items.get(index), ItemTransportFlow.WITHDRAW));
                    }
                    Iterator<Object> iterator = requests.iterator();
                    while (iterator.hasNext()) {
                        ItemRequest request = (ItemRequest)iterator.next();
                        if (!CargoNet.this.terminals.contains(request.getTerminal()) && !CargoNet.this.imports.contains(request.getTerminal()) && !CargoNet.this.exports.contains(request.getTerminal())) continue;
                        menu = BlockStorage.getInventory(request.getTerminal());
                        switch (request.getDirection()) {
                            case INSERT: {
                                ItemStack stack = request.getItem();
                                for (Location l : destinations) {
                                    Block target2 = CargoNet.getAttachedBlock(l.getBlock());
                                    stack = CargoManager.insert(l.getBlock(), storage, target2, stack, -1);
                                    if (stack != null) continue;
                                    menu.replaceExistingItem(request.getSlot(), null);
                                    break;
                                }
                                if (stack != null) {
                                    menu.replaceExistingItem(request.getSlot(), stack);
                                }
                                iterator.remove();
                                break;
                            }
                            case WITHDRAW: {
                                int slot = request.getSlot();
                                ItemStack prevStack = menu.getItemInSlot(slot);
                                if (!(prevStack == null || prevStack.getAmount() + request.getItem().getAmount() <= prevStack.getMaxStackSize() && SlimefunManager.isItemSimiliar(prevStack, (ItemStack)new CustomItem(request.getItem(), 1), true, SlimefunManager.DataType.ALWAYS))) {
                                    iterator.remove();
                                    break;
                                }
                                Object stack = null;
                                ItemStack requested = request.getItem();
                                for (Location l : providers) {
                                    Block target3 = CargoNet.getAttachedBlock(l.getBlock());
                                    ItemStack is = CargoManager.withdraw(l.getBlock(), storage, target3, requested);
                                    if (is == null) continue;
                                    stack = stack == null ? is : new CustomItem(stack, stack.getAmount() + is.getAmount());
                                    if (is.getAmount() == requested.getAmount()) break;
                                    requested = new CustomItem(requested, requested.getAmount() - is.getAmount());
                                }
                                if (stack != null) {
                                    ItemStack prev = menu.getItemInSlot(slot);
                                    if (prev == null) {
                                        menu.replaceExistingItem(slot, (ItemStack)stack);
                                    } else {
                                        menu.replaceExistingItem(slot, (ItemStack)new CustomItem(stack, stack.getAmount() + prev.getAmount()));
                                    }
                                }
                                iterator.remove();
                                break;
                            }
                        }
                    }
                }
                for (Location input : CargoNet.this.inputNodes) {
                    ChestMenu menu;
                    ItemSlot slot;
                    Integer frequency = CargoNet.getFrequency(input);
                    if (frequency < 0 || frequency > 15) continue;
                    Block inputTarget = CargoNet.getAttachedBlock(input.getBlock());
                    ItemStack stack = null;
                    int previousSlot = -1;
                    boolean roundrobin = BlockStorage.getLocationInfo(input, "round-robin").equals("true");
                    if (inputTarget != null && (slot = CargoManager.withdraw(input.getBlock(), storage, inputTarget, Integer.parseInt(BlockStorage.getLocationInfo(input, "index")))) != null) {
                        stack = slot.getItem();
                        previousSlot = slot.getSlot();
                    }
                    if (stack != null && output.containsKey(frequency)) {
                        Location out;
                        Block target;
                        ArrayList<Location> outputlist = new ArrayList<Location>((Collection)output.get(frequency));
                        if (roundrobin) {
                            int c_index;
                            if (!round_robin.containsKey(input)) {
                                round_robin.put(input, 0);
                            }
                            if ((c_index = round_robin.get(input).intValue()) < outputlist.size()) {
                                for (int i = 0; i < c_index; ++i) {
                                    Location temp = (Location)outputlist.get(0);
                                    outputlist.remove(temp);
                                    outputlist.add(temp);
                                }
                                ++c_index;
                            } else {
                                c_index = 1;
                            }
                            round_robin.put(input, c_index);
                        }
                        Iterator c_index = outputlist.iterator();
                        while (c_index.hasNext() && ((target = CargoNet.getAttachedBlock((out = (Location)c_index.next()).getBlock())) == null || (stack = CargoManager.insert(out.getBlock(), storage, target, stack, -1)) != null)) {
                        }
                    }
                    if (stack == null || previousSlot <= -1) continue;
                    if (storage.hasUniversalInventory(inputTarget)) {
                        menu = storage.getUniversalInventory(inputTarget);
                        menu.replaceExistingItem(previousSlot, stack);
                        continue;
                    }
                    if (storage.hasInventory(inputTarget.getLocation())) {
                        menu = BlockStorage.getInventory(inputTarget.getLocation());
                        menu.replaceExistingItem(previousSlot, stack);
                        continue;
                    }
                    if (!(inputTarget.getState() instanceof InventoryHolder)) continue;
                    Inventory inv = ((InventoryHolder)inputTarget.getState()).getInventory();
                    inv.setItem(previousSlot, stack);
                }
                if (EXTRA_CHANNELS) {
                    ArrayList<StoredItem> items = new ArrayList<StoredItem>();
                    for (final Location l : providers) {
                        int inv;
                        ChestMenu menu;
                        Block target = CargoNet.getAttachedBlock(l.getBlock());
                        if (storage.hasUniversalInventory(target)) {
                            menu = storage.getUniversalInventory(target);
                            int[] previousSlot = menu.getPreset().getSlotsAccessedByItemTransport((UniversalBlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                            int roundrobin = previousSlot.length;
                            for (inv = 0; inv < roundrobin; ++inv) {
                                int slot = previousSlot[inv];
                                ItemStack is = menu.getItemInSlot(slot);
                                if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                boolean add = true;
                                for (StoredItem storedItem : items) {
                                    if (!SlimefunManager.isItemSimiliar(is, storedItem.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                    add = false;
                                    storedItem.add(is.getAmount());
                                }
                                if (!add) continue;
                                items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount()));
                            }
                            continue;
                        }
                        if (storage.hasInventory(target.getLocation())) {
                            menu = BlockStorage.getInventory(target.getLocation());
                            if (BlockStorage.checkID(target.getLocation()).startsWith("BARREL_") && BlockStorage.getLocationInfo(target.getLocation(), "storedItems") != null) {
                                int stored = Integer.valueOf(BlockStorage.getLocationInfo(target.getLocation(), "storedItems"));
                                int[] roundrobin = menu.getPreset().getSlotsAccessedByItemTransport((BlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                                inv = roundrobin.length;
                                for (int slot = 0; slot < inv; ++slot) {
                                    int slot2 = roundrobin[slot];
                                    ItemStack is = menu.getItemInSlot(slot2);
                                    if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                    boolean add = true;
                                    for (StoredItem item2 : items) {
                                        if (!SlimefunManager.isItemSimiliar(is, item2.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                        add = false;
                                        item2.add(is.getAmount() + stored);
                                    }
                                    if (!add) continue;
                                    items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount() + stored));
                                }
                                continue;
                            }
                            int[] stored = menu.getPreset().getSlotsAccessedByItemTransport((BlockMenu)menu, ItemTransportFlow.WITHDRAW, null);
                            int roundrobin = stored.length;
                            for (inv = 0; inv < roundrobin; ++inv) {
                                int slot = stored[inv];
                                ItemStack is = menu.getItemInSlot(slot);
                                if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                                boolean add = true;
                                for (StoredItem storedItem : items) {
                                    if (!SlimefunManager.isItemSimiliar(is, storedItem.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                    add = false;
                                    storedItem.add(is.getAmount());
                                }
                                if (!add) continue;
                                items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount()));
                            }
                            continue;
                        }
                        if (!(target.getState() instanceof InventoryHolder)) continue;
                        Inventory inv2 = ((InventoryHolder)target.getState()).getInventory();
                        ItemStack[] stored = inv2.getContents();
                        int roundrobin = stored.length;
                        for (inv = 0; inv < roundrobin; ++inv) {
                            ItemStack is = stored[inv];
                            if (is == null || !CargoManager.matchesFilter(l.getBlock(), is, -1)) continue;
                            boolean add = true;
                            for (StoredItem item : items) {
                                if (!SlimefunManager.isItemSimiliar(is, item.getItem(), true, SlimefunManager.DataType.ALWAYS)) continue;
                                add = false;
                                item.add(is.getAmount());
                            }
                            if (!add) continue;
                            items.add(new StoredItem((ItemStack)new CustomItem(is, 1), is.getAmount()));
                        }
                    }
                    Collections.sort(items, sorter);
                    for (final Location l : CargoNet.this.terminals) {
                        BlockMenu menu = BlockStorage.getInventory(l);
                        int page = Integer.parseInt(BlockStorage.getLocationInfo(l, "page"));
                        if (!items.isEmpty() && items.size() < (page - 1) * terminal_slots.length + 1) {
                            page = 1;
                            BlockStorage.addBlockInfo(l, "page", String.valueOf(1));
                        }
                        for (int i = 0; i < terminal_slots.length; ++i) {
                            int slot = terminal_slots[i];
                            if (items.size() > i + terminal_slots.length * (page - 1)) {
                                final StoredItem item = (StoredItem)items.get(i + terminal_slots.length * (page - 1));
                                ItemStack stack = item.getItem().clone();
                                ItemMeta im = stack.getItemMeta();
                                ArrayList<String> lore = new ArrayList<String>();
                                lore.add("");
                                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Stored Items: &r" + DoubleHandler.getFancyDouble((double)item.getAmount()))));
                                if (stack.getMaxStackSize() > 1) {
                                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7<Left Click: Request 1 | Right Click: Request " + (item.getAmount() > stack.getMaxStackSize() ? stack.getMaxStackSize() : item.getAmount()) + ">")));
                                } else {
                                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7<Left Click: Request 1>"));
                                }
                                lore.add("");
                                if (im.hasLore()) {
                                    for (String string : im.getLore()) {
                                        lore.add(string);
                                    }
                                }
                                im.setLore(lore);
                                stack.setItemMeta(im);
                                menu.replaceExistingItem(slot, stack);
                                menu.addMenuClickHandler(slot, new ChestMenu.MenuClickHandler(){

                                    public boolean onClick(Player p, int slot, ItemStack is, ClickAction action) {
                                        requests.add(new ItemRequest(l, 44, (ItemStack)new CustomItem(item.getItem(), action.isRightClicked() ? (item.getAmount() > item.getItem().getMaxStackSize() ? item.getItem().getMaxStackSize() : item.getAmount()) : 1), ItemTransportFlow.WITHDRAW));
                                        return false;
                                    }
                                });
                                continue;
                            }
                            menu.replaceExistingItem(slot, terminal_noitem_item);
                            menu.addMenuClickHandler(slot, terminal_noitem_handler);
                        }
                        ItemStack sent_item = menu.getItemInSlot(17);
                        if (sent_item == null) continue;
                        requests.add(new ItemRequest(l, 17, sent_item, ItemTransportFlow.INSERT));
                    }
                }
            }
        });
    }

    private static Block getAttachedBlock(Block block) {
        if (block.getData() == 2) {
            return block.getRelative(BlockFace.SOUTH);
        }
        if (block.getData() == 3) {
            return block.getRelative(BlockFace.NORTH);
        }
        if (block.getData() == 4) {
            return block.getRelative(BlockFace.EAST);
        }
        if (block.getData() == 5) {
            return block.getRelative(BlockFace.WEST);
        }
        return null;
    }

    private static int getFrequency(Location l) {
        int freq = 0;
        try {
            freq = Integer.parseInt(BlockStorage.getLocationInfo(l).getString("frequency"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return freq;
    }
}

