/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.OptionalMap;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class PerWorldSettingsService {
    private final SlimefunPlugin plugin;
    private final OptionalMap<String, Set<String>> disabledItems = new OptionalMap(HashMap::new);
    private final Map<SlimefunAddon, Set<String>> disabledAddons = new HashMap<SlimefunAddon, Set<String>>();
    private final Set<String> disabledWorlds = new HashSet<String>();

    public PerWorldSettingsService(SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public void load(Iterable<World> worlds) {
        try {
            this.migrate();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occured while migrating old world settings", e);
        }
        for (World world : worlds) {
            this.load(world);
        }
    }

    public void load(World world) {
        this.disabledItems.putIfAbsent(world.getName(), this.loadWorldFromConfig(world.getName()));
    }

    private void migrate() throws IOException {
        Config oldConfig = new Config((Plugin)this.plugin, "whitelist.yml");
        if (oldConfig.getFile().exists()) {
            for (String world : oldConfig.getKeys()) {
                Config newConfig = new Config((Plugin)this.plugin, "world-settings/" + world + ".yml");
                newConfig.setDefaultValue("enabled", oldConfig.getBoolean(world + ".enabled"));
                for (String id : oldConfig.getKeys(world + ".enabled-items")) {
                    SlimefunItem item = SlimefunItem.getByID(id);
                    if (item == null) continue;
                    String addon = item.getAddon().getName().toLowerCase(Locale.ROOT);
                    newConfig.setDefaultValue(addon + ".enabled", true);
                    newConfig.setDefaultValue(addon + '.' + id, oldConfig.getBoolean(world + ".enabled-items." + id));
                }
                newConfig.save();
            }
            Files.delete(oldConfig.getFile().toPath());
        }
    }

    public boolean isEnabled(World world, SlimefunItem item) {
        Set items = this.disabledItems.computeIfAbsent(world.getName(), this::loadWorldFromConfig);
        if (this.disabledWorlds.contains(world.getName())) {
            return false;
        }
        return !items.contains(item.getID());
    }

    public void setEnabled(World world, SlimefunItem item, boolean enabled) {
        Set items = this.disabledItems.computeIfAbsent(world.getName(), this::loadWorldFromConfig);
        if (enabled) {
            items.remove(item.getID());
        } else {
            items.add(item.getID());
        }
    }

    public boolean isWorldEnabled(World world) {
        this.load(world);
        return !this.disabledWorlds.contains(world.getName());
    }

    public boolean isAddonEnabled(World world, SlimefunAddon addon) {
        return this.isWorldEnabled(world) && this.disabledAddons.getOrDefault(addon, Collections.emptySet()).contains(world.getName());
    }

    public void save(World world) {
        Set items = this.disabledItems.computeIfAbsent(world.getName(), this::loadWorldFromConfig);
        Config config = new Config((Plugin)this.plugin, "world-settings/" + world + ".yml");
        for (SlimefunItem item : SlimefunPlugin.getRegistry().getEnabledSlimefunItems()) {
            if (item == null || item.getID() == null) continue;
            String addon = item.getAddon().getName().toLowerCase(Locale.ROOT);
            config.setValue(addon + '.' + item.getID(), !items.contains(item.getID()));
        }
        config.save();
    }

    private Set<String> loadWorldFromConfig(String name) {
        Optional<Set<String>> optional = this.disabledItems.get(name);
        if (optional.isPresent()) {
            return optional.get();
        }
        LinkedHashSet<String> items = new LinkedHashSet<String>();
        Config config = new Config((Plugin)this.plugin, "world-settings/" + name + ".yml");
        config.getConfiguration().options().header("This file is used to disable certain items in a particular world.\nYou can set any item to 'false' to disable it in the world '" + name + "'.\nYou can also disable an entire addon from Slimefun by setting the respective\nvalue of 'enabled' for that Addon.\n\nItems which are disabled in this world will not show up in the Slimefun Guide.\nYou won't be able to use these items either. Using them will result in a warning message.");
        config.getConfiguration().options().copyHeader(true);
        config.setDefaultValue("enabled", true);
        if (config.getBoolean("enabled")) {
            for (SlimefunItem item : SlimefunPlugin.getRegistry().getEnabledSlimefunItems()) {
                if (item == null || item.getID() == null) continue;
                String addon = item.getAddon().getName().toLowerCase(Locale.ROOT);
                config.setDefaultValue(addon + ".enabled", true);
                config.setDefaultValue(addon + '.' + item.getID(), true);
                boolean isAddonDisabled = config.getBoolean(addon + ".enabled");
                if (isAddonDisabled) {
                    Set blacklist = this.disabledAddons.computeIfAbsent(this.plugin, key -> new HashSet());
                    blacklist.add(name);
                }
                if (isAddonDisabled && config.getBoolean(addon + '.' + item.getID())) continue;
                items.add(item.getID());
            }
            config.save();
        } else {
            this.disabledWorlds.add(name);
        }
        return items;
    }
}

