/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.geo;

import io.github.thebusybiscuit.slimefun4.api.events.GEOResourceGenerationEvent;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ResourceManager {
    private final int[] backgroundSlots = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 48, 49, 50, 52, 53};
    private final ItemStack chunkTexture = SkullItem.fromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODQ0OWI5MzE4ZTMzMTU4ZTY0YTQ2YWIwZGUxMjFjM2Q0MDAwMGUzMzMyYzE1NzQ5MzJiM2M4NDlkOGZhMGRjMiJ9fX0=");
    private final Config config;

    public ResourceManager(SlimefunPlugin plugin) {
        this.config = new Config((Plugin)plugin, "resources.yml");
    }

    void register(GEOResource resource) {
        boolean enabled = this.config.getOrSetDefault(resource.getKey().toString().replace(':', '.') + ".enabled", true);
        if (enabled) {
            SlimefunPlugin.getRegistry().getGEOResources().add(resource);
        }
        this.config.save();
    }

    public OptionalInt getSupplies(GEOResource resource, World world, int x, int z) {
        String key = resource.getKey().toString().replace(':', '-');
        String value = BlockStorage.getChunkInfo(world, x, z, key);
        if (value != null) {
            return OptionalInt.of(Integer.parseInt(value));
        }
        return OptionalInt.empty();
    }

    public void setSupplies(GEOResource resource, World world, int x, int z, int value) {
        String key = resource.getKey().toString().replace(':', '-');
        BlockStorage.setChunkInfo(world, x, z, key, String.valueOf(value));
    }

    private int generate(GEOResource resource, World world, int x, int z) {
        Block block = world.getBlockAt(x << 4, 72, z << 4);
        int value = resource.getDefaultSupply(world.getEnvironment(), block.getBiome());
        if (value > 0) {
            int bound = resource.getMaxDeviation();
            if (bound <= 0) {
                throw new IllegalStateException("GEO Resource \"" + resource.getKey() + "\" was misconfigured! getMaxDeviation() must return a value higher than zero!");
            }
            value += ThreadLocalRandom.current().nextInt(bound);
        }
        GEOResourceGenerationEvent event = new GEOResourceGenerationEvent(world, block.getBiome(), x, z, resource, value);
        Bukkit.getPluginManager().callEvent((Event)event);
        value = event.getValue();
        this.setSupplies(resource, world, x, z, value);
        return value;
    }

    public void scan(Player p, Block block, int page) {
        if (SlimefunPlugin.getGPSNetwork().getNetworkComplexity(p.getUniqueId()) < 600) {
            SlimefunPlugin.getLocal().sendMessages((CommandSender)p, "gps.insufficient-complexity", true, msg -> msg.replace("%complexity%", "600"));
            return;
        }
        int x = block.getX() >> 4;
        int z = block.getZ() >> 4;
        ChestMenu menu = new ChestMenu("&4" + SlimefunPlugin.getLocal().getResourceString(p, "tooltips.results"));
        for (int slot2 : this.backgroundSlots) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(4, (ItemStack)new CustomItem(this.chunkTexture, "&e" + SlimefunPlugin.getLocal().getResourceString(p, "tooltips.chunk"), "", "&8\u21e8 &7" + SlimefunPlugin.getLocal().getResourceString(p, "tooltips.world") + ": " + block.getWorld().getName(), "&8\u21e8 &7X: " + x + " Z: " + z), ChestMenuUtils.getEmptyClickHandler());
        ArrayList resources = new ArrayList(SlimefunPlugin.getRegistry().getGEOResources().values());
        Collections.sort(resources, (a, b) -> a.getName(p).toLowerCase(Locale.ROOT).compareTo(b.getName(p).toLowerCase(Locale.ROOT)));
        int index = 10;
        int pages = (resources.size() - 1) / 36 + 1;
        for (int i = page * 28; i < resources.size() && i < (page + 1) * 28; ++i) {
            GEOResource resource = (GEOResource)resources.get(i);
            OptionalInt optional = this.getSupplies(resource, block.getWorld(), x, z);
            int supplies = optional.isPresent() ? optional.getAsInt() : this.generate(resource, block.getWorld(), x, z);
            String suffix = SlimefunPlugin.getLocal().getResourceString(p, supplies == 1 ? "tooltips.unit" : "tooltips.units");
            CustomItem item2 = new CustomItem(resource.getItem(), "&r" + resource.getName(p), "&8\u21e8 &e" + supplies + ' ' + suffix);
            if (supplies > 1) {
                item2.setAmount(supplies > item2.getMaxStackSize() ? item2.getMaxStackSize() : supplies);
            }
            menu.addItem(index, (ItemStack)item2, ChestMenuUtils.getEmptyClickHandler());
            if (++index % 9 != 8) continue;
            index += 2;
        }
        menu.addItem(47, ChestMenuUtils.getPreviousButton(p, page + 1, pages));
        menu.addMenuClickHandler(47, (pl, slot, item, action) -> {
            if (page > 0) {
                this.scan(pl, block, page - 1);
            }
            return false;
        });
        menu.addItem(51, ChestMenuUtils.getNextButton(p, page + 1, pages));
        menu.addMenuClickHandler(51, (pl, slot, item, action) -> {
            if (page + 1 < pages) {
                this.scan(pl, block, page + 1);
            }
            return false;
        });
        menu.open(new Player[]{p});
    }
}

