/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.implementation.listeners.ButcherAndroidListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.NetworkListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TeleporterListener;
import io.github.thebusybiscuit.slimefun4.implementation.setup.PostSetup;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class SlimefunStartupTask
implements Runnable {
    private final SlimefunPlugin plugin;
    private final Runnable runnable;

    public SlimefunStartupTask(SlimefunPlugin plugin, Runnable runnable) {
        this.plugin = plugin;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        this.runnable.run();
        PostSetup.loadItems();
        SlimefunPlugin.getWorldSettingsService().load(Bukkit.getWorlds());
        for (World world : Bukkit.getWorlds()) {
            new BlockStorage(world);
        }
        if (this.isEnabled("ELEVATOR_PLATE", "GPS_ACTIVATION_DEVICE_SHARED", "GPS_ACTIVATION_DEVICE_PERSONAL")) {
            new TeleporterListener(this.plugin);
        }
        if (this.isEnabled("PROGRAMMABLE_ANDROID_BUTCHER", "PROGRAMMABLE_ANDROID_2_BUTCHER", "PROGRAMMABLE_ANDROID_3_BUTCHER")) {
            new ButcherAndroidListener(this.plugin);
        }
        if (this.isEnabled("ENERGY_REGULATOR", "CARGO_MANAGER")) {
            new NetworkListener(this.plugin);
        }
    }

    private boolean isEnabled(String ... itemIds) {
        for (String id : itemIds) {
            SlimefunItem item = SlimefunItem.getByID(id);
            if (item == null || item.isDisabled()) continue;
            return true;
        }
        return false;
    }
}

