/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.blocks;

import java.lang.ref.WeakReference;
import lombok.NonNull;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public final class BlockPosition {
    private final WeakReference<World> world;
    private final long position;

    public BlockPosition(@NonNull World world, long position) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = new WeakReference<World>(world);
        this.position = position;
    }

    public BlockPosition(@NonNull World world, int x, int y, int z) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = new WeakReference<World>(world);
        this.position = (long)(x & 0x3FFFFFF) << 38 | (long)(z & 0x3FFFFFF) << 12 | (long)(y & 0xFFF);
    }

    public World getWorld() {
        World world = (World)this.world.get();
        if (world == null) {
            throw new IllegalStateException("The reference of this BlockPositions world has been cleared");
        }
        return world;
    }

    public long getPosition() {
        return this.position;
    }

    public int getX() {
        return (int)(this.position >> 38);
    }

    public int getY() {
        return (int)(this.position & 0xFFFL);
    }

    public int getZ() {
        return (int)(this.position << 26 >> 38);
    }

    public Block getBlock() {
        return this.getChunk().getBlock(this.getX() & 0xF, this.getY(), this.getZ() & 0xF);
    }

    public Chunk getChunk() {
        World world = (World)this.world.get();
        if (world == null) {
            throw new IllegalStateException("Cannot get Chunk when the world isn't loaded");
        }
        return world.getChunkAt(this.getChunkX(), this.getChunkZ());
    }

    public int getChunkX() {
        return this.getX() >> 4;
    }

    public int getChunkZ() {
        return this.getZ() >> 4;
    }

    public Location toLocation() {
        return new Location((World)this.world.get(), (double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public boolean equals(Object o) {
        if (o instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)o;
            if (pos.world.get() == null) {
                return false;
            }
            return this.getWorld().getUID().equals(pos.getWorld().getUID()) && this.position == pos.position;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        World ref = (World)this.world.get();
        int result = 0;
        result += 31 * (ref == null ? 0 : ref.hashCode());
        return result += 31 * Long.hashCode(this.position);
    }

    public String toString() {
        return String.format("BlockPosition(world=%s, x=%d, y=%d, z=%d, position=%d)", this.getWorld().getName(), this.getX(), this.getY(), this.getZ(), this.getPosition());
    }
}

