/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.cscorelib2.players.MinecraftAccount;

class GitHubTask
implements Runnable {
    private final GitHubService gitHubService;

    GitHubTask(GitHubService github) {
        this.gitHubService = github;
    }

    @Override
    public void run() {
        this.gitHubService.getConnectors().forEach(GitHubConnector::pullFile);
        HashMap<String, String> skins = new HashMap<String, String>();
        for (Contributor contributor : this.gitHubService.getContributors().values()) {
            if (contributor.hasTexture()) continue;
            try {
                if (skins.containsKey(contributor.getMinecraftName())) {
                    contributor.setTexture((String)skins.get(contributor.getMinecraftName()));
                    continue;
                }
                contributor.setTexture(this.grabTexture(skins, contributor.getMinecraftName()));
            }
            catch (IllegalArgumentException x) {
                contributor.setTexture(null);
            }
            catch (Exception x) {
                break;
            }
        }
    }

    private String grabTexture(Map<String, String> skins, String username) throws MinecraftAccount.TooManyRequestsException, IOException {
        Optional<UUID> uuid = MinecraftAccount.getUUID(username);
        if (uuid.isPresent()) {
            Optional<String> skin = MinecraftAccount.getSkin(uuid.get());
            skins.put(username, skin.orElse(""));
            return skin.orElse(null);
        }
        return null;
    }
}

