/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import java.util.HashSet;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class BlockMenuPreset
extends ChestMenu {
    private String inventoryTitle;
    private Set<Integer> occupied = new HashSet<Integer>();
    private String id;
    private int size = -1;
    private boolean universal;
    private ItemManipulationEvent event;

    public BlockMenuPreset(String id, String title) {
        this(id, title, false);
    }

    public BlockMenuPreset(String id, String title, boolean universal) {
        super(title);
        this.id = id;
        this.inventoryTitle = title;
        this.init();
        this.universal = universal;
        SlimefunPlugin.getRegistry().getMenuPresets().put(id, this);
    }

    public abstract void init();

    public abstract boolean canOpen(Block var1, Player var2);

    public abstract int[] getSlotsAccessedByItemTransport(ItemTransportFlow var1);

    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public void newInstance(BlockMenu menu, Block b) {
    }

    public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
        return this.getSlotsAccessedByItemTransport(flow);
    }

    public ChestMenu addItem(int slot, ItemStack item) {
        this.occupied.add(slot);
        return super.addItem(slot, item);
    }

    public ChestMenu setSize(int size) {
        this.size = size;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.inventoryTitle;
    }

    public Set<Integer> getPresetSlots() {
        return this.occupied;
    }

    public Set<Integer> getInventorySlots() {
        HashSet<Integer> empty = new HashSet<Integer>();
        if (this.size > -1) {
            for (int i = 0; i < this.size; ++i) {
                if (this.occupied.contains(i)) continue;
                empty.add(i);
            }
        } else {
            for (int i = 0; i < this.toInventory().getSize(); ++i) {
                if (this.occupied.contains(i)) continue;
                empty.add(i);
            }
        }
        return empty;
    }

    public static BlockMenuPreset getPreset(String id) {
        return id == null ? null : SlimefunPlugin.getRegistry().getMenuPresets().get(id);
    }

    public static boolean isInventory(String id) {
        return SlimefunPlugin.getRegistry().getMenuPresets().containsKey(id);
    }

    public static boolean isUniversalInventory(String id) {
        BlockMenuPreset preset = SlimefunPlugin.getRegistry().getMenuPresets().get(id);
        return preset != null && preset.isUniversal();
    }

    public boolean isUniversal() {
        return this.universal;
    }

    protected void clone(DirtyChestMenu menu) {
        menu.setPlayerInventoryClickable(true);
        for (int slot : this.occupied) {
            menu.addItem(slot, this.getItemInSlot(slot));
        }
        if (this.size > -1) {
            menu.addItem(this.size - 1, null);
        }
        if (menu instanceof BlockMenu) {
            BlockMenu blockMenu = (BlockMenu)menu;
            this.newInstance(blockMenu, blockMenu.getLocation());
        }
        for (int slot = 0; slot < 54; ++slot) {
            if (this.getMenuClickHandler(slot) == null) continue;
            menu.addMenuClickHandler(slot, this.getMenuClickHandler(slot));
        }
        menu.addMenuOpeningHandler(this.getMenuOpeningHandler());
        menu.addMenuCloseHandler(this.getMenuCloseHandler());
        menu.registerEvent(this.event);
    }

    public String getID() {
        return this.id;
    }

    public SlimefunItem getSlimefunItem() {
        return SlimefunItem.getByID(this.id);
    }

    public void newInstance(BlockMenu menu, Location l) {
        Slimefun.runSync(() -> {
            try {
                this.newInstance(menu, l.getBlock());
            }
            catch (Throwable x) {
                this.getSlimefunItem().error("An eror occured while trying to create a BlockMenu", x);
            }
        });
    }
}

