/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ChestTerminalNetwork;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CargoNet
extends ChestTerminalNetwork {
    private static final int RANGE = 5;
    private final Set<Location> inputNodes = new HashSet<Location>();
    private final Set<Location> outputNodes = new HashSet<Location>();
    private final Map<Location, Integer> roundRobin = new HashMap<Location, Integer>();

    public static CargoNet getNetworkFromLocation(Location l) {
        return SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, CargoNet.class);
    }

    public static CargoNet getNetworkFromLocationOrCreate(Location l) {
        CargoNet cargoNetwork = CargoNet.getNetworkFromLocation(l);
        if (cargoNetwork == null) {
            cargoNetwork = new CargoNet(l);
            SlimefunPlugin.getNetworkManager().registerNetwork(cargoNetwork);
        }
        return cargoNetwork;
    }

    protected CargoNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        switch (id) {
            case "CARGO_MANAGER": {
                return NetworkComponent.REGULATOR;
            }
            case "CARGO_NODE": {
                return NetworkComponent.CONNECTOR;
            }
            case "CARGO_NODE_INPUT": 
            case "CARGO_NODE_OUTPUT": 
            case "CARGO_NODE_OUTPUT_ADVANCED": 
            case "CT_IMPORT_BUS": 
            case "CT_EXPORT_BUS": 
            case "CHEST_TERMINAL": {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
            this.terminals.remove(l);
            this.imports.remove(l);
            this.exports.remove(l);
        }
        if (to == NetworkComponent.TERMINUS) {
            switch (BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": 
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.outputNodes.add(l);
                    break;
                }
                case "CHEST_TERMINAL": {
                    this.terminals.add(l);
                    break;
                }
                case "CT_IMPORT_BUS": {
                    this.imports.add(l);
                    break;
                }
                case "CT_EXPORT_BUS": {
                    this.exports.add(l);
                    break;
                }
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&cNo Cargo Nodes found");
        } else {
            SimpleHologram.update(b, "&7Status: &a&lONLINE");
            Map<Integer, List<Location>> output = this.mapOutputNodes();
            HashSet<Location> destinations = new HashSet<Location>();
            List<Location> output16 = output.get(16);
            if (output16 != null) {
                destinations.addAll(output16);
            }
            Slimefun.runSync(() -> this.run(b, destinations, output));
        }
    }

    private Map<Integer, List<Location>> mapOutputNodes() {
        HashMap<Integer, List<Location>> output = new HashMap<Integer, List<Location>>();
        LinkedList<Location> list = new LinkedList<Location>();
        int lastFrequency = -1;
        for (Location outputNode : this.outputNodes) {
            int frequency = CargoNet.getFrequency(outputNode);
            if (frequency != lastFrequency && lastFrequency != -1) {
                output.merge(lastFrequency, list, (prev, next) -> {
                    prev.addAll(next);
                    return prev;
                });
                list = new LinkedList();
            }
            list.add(outputNode);
            lastFrequency = frequency;
        }
        if (!list.isEmpty()) {
            output.merge(lastFrequency, list, (prev, next) -> {
                prev.addAll(next);
                return prev;
            });
        }
        return output;
    }

    private void run(Block b, Set<Location> destinations, Map<Integer, List<Location>> output) {
        if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
            this.display();
        }
        HashMap<Location, Integer> inputs = new HashMap<Location, Integer>();
        HashSet<Location> providers = new HashSet<Location>();
        for (Location location : this.inputNodes) {
            int frequency = CargoNet.getFrequency(location);
            if (frequency == 16) {
                providers.add(location);
                continue;
            }
            if (frequency < 0 || frequency >= 16) continue;
            inputs.put(location, frequency);
        }
        if (SlimefunPlugin.getThirdPartySupportService().isChestTerminalInstalled()) {
            this.handleItemRequests(providers, destinations);
        }
        for (Map.Entry entry : inputs.entrySet()) {
            Location input = (Location)entry.getKey();
            Optional<Block> inputTarget = CargoNet.getAttachedBlock(input.getBlock());
            if (!inputTarget.isPresent()) continue;
            int previousSlot = -1;
            Config cfg = BlockStorage.getLocationInfo(input);
            boolean roundrobin = "true".equals(cfg.getString("round-robin"));
            ItemStackAndInteger slot = CargoUtils.withdraw(input.getBlock(), inputTarget.get(), Integer.parseInt(cfg.getString("index")));
            ItemStack stack = null;
            if (slot != null) {
                stack = slot.getItem();
                previousSlot = slot.getInt();
            }
            if (stack == null) continue;
            List<Location> outputs = output.get(entry.getValue());
            if (outputs != null) {
                Location out;
                Optional<Block> target;
                LinkedList<Location> outputlist = new LinkedList<Location>(outputs);
                if (roundrobin) {
                    int index = this.roundRobin.getOrDefault(input, 0);
                    if (index < outputlist.size()) {
                        for (int i = 0; i < index; ++i) {
                            Location temp = (Location)outputlist.remove(0);
                            outputlist.add(temp);
                        }
                        ++index;
                    } else {
                        index = 1;
                    }
                    this.roundRobin.put(input, index);
                }
                Iterator index = outputlist.iterator();
                while (index.hasNext() && (!(target = CargoNet.getAttachedBlock((out = (Location)index.next()).getBlock())).isPresent() || (stack = CargoUtils.insert(out.getBlock(), target.get(), stack, -1)) != null)) {
                }
            }
            if (stack == null || previousSlot <= -1) continue;
            DirtyChestMenu menu = CargoUtils.getChestMenu(inputTarget.get());
            if (menu != null) {
                menu.replaceExistingItem(previousSlot, stack);
                continue;
            }
            BlockState state = inputTarget.get().getState();
            if (!(state instanceof InventoryHolder)) continue;
            Inventory inv = ((InventoryHolder)state).getInventory();
            inv.setItem(previousSlot, stack);
        }
        if (SlimefunPlugin.getThirdPartySupportService().isChestTerminalInstalled()) {
            this.updateTerminals(providers);
        }
    }

    private static int getFrequency(Location l) {
        try {
            String str = BlockStorage.getLocationInfo(l).getString("frequency");
            return Integer.parseInt(str);
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while parsing a Cargo Node Frequency", x);
            return 0;
        }
    }
}

