/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;

public class MultiBlock {
    public static final List<Tag<Material>> SUPPORTED_TAGS = new ArrayList<Tag<Material>>();
    private final SlimefunItem item;
    private final Material[] blocks;
    private final BlockFace trigger;
    private final boolean isSymmetric;

    public MultiBlock(SlimefunItem item, Material[] build, BlockFace trigger) {
        this.item = item;
        if (trigger != BlockFace.SELF && trigger != BlockFace.UP && trigger != BlockFace.DOWN) {
            throw new IllegalArgumentException("Multiblock Blockface must be either UP, DOWN or SELF");
        }
        this.blocks = build;
        this.trigger = trigger;
        this.isSymmetric = MultiBlock.isSymmetric(build);
    }

    public SlimefunItem getSlimefunItem() {
        return this.item;
    }

    private static boolean isSymmetric(Material[] blocks) {
        return blocks[0] == blocks[2] && blocks[3] == blocks[5] && blocks[6] == blocks[8];
    }

    public Material[] getStructure() {
        return this.blocks;
    }

    public BlockFace getTriggerBlock() {
        return this.trigger;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiBlock)) {
            return false;
        }
        MultiBlock mb = (MultiBlock)obj;
        if (this.trigger == mb.getTriggerBlock()) {
            for (int i = 0; i < mb.getStructure().length; ++i) {
                if (this.compareBlocks(this.blocks[i], mb.getStructure()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.item.getID(), this.blocks, this.trigger, this.isSymmetric);
    }

    private boolean compareBlocks(Material a, Material b) {
        if (b != null) {
            for (Tag<Material> tag : SUPPORTED_TAGS) {
                if (!tag.isTagged((Keyed)b)) continue;
                return tag.isTagged((Keyed)a);
            }
            if (b != a) {
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }

    public String toString() {
        return "MultiBlock (" + this.item.getID() + ") {" + Arrays.toString(this.blocks) + "}";
    }

    static {
        SUPPORTED_TAGS.add((Tag<Material>)Tag.LOGS);
        SUPPORTED_TAGS.add((Tag<Material>)Tag.WOODEN_TRAPDOORS);
        SUPPORTED_TAGS.add((Tag<Material>)Tag.WOODEN_SLABS);
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            SUPPORTED_TAGS.add((Tag<Material>)Tag.WOODEN_FENCES);
        }
    }
}

