/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.implementation.tasks.PlayerTask;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;

public class MagnetTask
extends PlayerTask {
    private final double radius;

    public MagnetTask(Player p, double radius) {
        super(p);
        this.radius = radius;
    }

    @Override
    public void executeTask() {
        boolean playSound = false;
        for (Entity n : this.p.getNearbyEntities(this.radius, this.radius, this.radius)) {
            Item item;
            if (!(n instanceof Item) || SlimefunUtils.hasNoPickupFlag(item = (Item)n) || item.getPickupDelay() > 0 || !(this.p.getLocation().distanceSquared(item.getLocation()) > 0.3)) continue;
            item.teleport(this.p.getLocation());
            playSound = true;
        }
        if (playSound) {
            this.p.playSound(this.p.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.25f, 0.9f);
        }
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && this.p.getGameMode() != GameMode.SPECTATOR;
    }
}

