/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets;

import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.MultiToolMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ChargableItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ItemEnergy;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MultiTool
extends ChargableItem {
    private static final float COST = 0.3f;
    private final Map<UUID, Integer> selectedMode = new HashMap<UUID, Integer>();
    private final List<MultiToolMode> modes = new ArrayList<MultiToolMode>();

    public MultiTool(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String ... items) {
        super(Categories.TECH, item, recipeType, recipe);
        for (int i = 0; i < items.length; ++i) {
            this.modes.add(new MultiToolMode(this, i, items[i]));
        }
    }

    protected ItemUseHandler getItemUseHandler() {
        return e -> {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            e.cancel();
            int index = this.selectedMode.getOrDefault(p.getUniqueId(), 0);
            if (!p.isSneaking()) {
                float charge = ItemEnergy.getStoredEnergy(item);
                if (charge >= 0.3f) {
                    ItemEnergy.chargeItem(item, -0.3f);
                    SlimefunItem sfItem = this.modes.get(index).getItem();
                    if (sfItem != null) {
                        sfItem.callItemHandler(ItemUseHandler.class, handler -> handler.onRightClick(e));
                    }
                }
            } else {
                SlimefunItem selectedItem = this.modes.get(index = this.nextIndex(index)).getItem();
                String itemName = selectedItem != null ? selectedItem.getItemName() : "Unknown";
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.mode-change", true, msg -> msg.replace("%device%", "Multi Tool").replace("%mode%", ChatColor.stripColor((String)itemName)));
                this.selectedMode.put(p.getUniqueId(), index);
            }
        };
    }

    private int nextIndex(int i) {
        int index = i;
        do {
            if (++index < this.modes.size()) continue;
            index = 0;
        } while (index != i && !this.modes.get(index).isEnabled());
        return index;
    }

    private BlockBreakHandler getBlockBreakHandler() {
        return (e, item, fortune, drops) -> {
            if (this.isItem(item)) {
                e.setCancelled(true);
                return true;
            }
            return false;
        };
    }

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(this.getItemUseHandler());
        this.addItemHandler(this.getBlockBreakHandler());
    }
}

