/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.util.LinkedList;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.MinecraftRecipe;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.RecipeSnapshot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class MinecraftRecipeService {
    private final Plugin plugin;
    private RecipeSnapshot snapshot;

    public MinecraftRecipeService(Plugin plugin) {
        this.plugin = plugin;
    }

    public void refresh() {
        this.snapshot = new RecipeSnapshot(this.plugin);
    }

    public Optional<ItemStack> getFurnaceOutput(ItemStack input) {
        return this.snapshot.getRecipeOutput(MinecraftRecipe.FURNACE, input);
    }

    public RecipeChoice[] getRecipeShape(Recipe recipe) {
        if (recipe instanceof ShapedRecipe) {
            LinkedList choices = new LinkedList();
            for (String row : ((ShapedRecipe)recipe).getShape()) {
                int columns = row.toCharArray().length;
                for (char key : row.toCharArray()) {
                    choices.add(((ShapedRecipe)recipe).getChoiceMap().get(Character.valueOf(key)));
                }
                while (columns < 3) {
                    choices.add(null);
                    ++columns;
                }
            }
            return choices.toArray(new RecipeChoice[0]);
        }
        return this.snapshot.getRecipeInput(recipe);
    }

    public Recipe[] getRecipesFor(ItemStack item) {
        if (item == null) {
            return new Recipe[0];
        }
        return this.snapshot.getRecipesFor(item).toArray(new Recipe[0]);
    }
}

