/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.items.food.Cooler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class CoolerListener
implements Listener {
    private final Cooler cooler;

    public CoolerListener(SlimefunPlugin plugin, Cooler cooler) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.cooler = cooler;
    }

    @EventHandler
    public void onStarve(FoodLevelChangeEvent e) {
        if (this.cooler.isDisabled()) {
            return;
        }
        if (e.getFoodLevel() < ((Player)e.getEntity()).getFoodLevel()) {
            Player p = (Player)e.getEntity();
            for (ItemStack item : p.getInventory().getContents()) {
                if (!this.cooler.isItem(item)) continue;
                if (Slimefun.hasUnlocked(p, this.cooler, true)) {
                    PlayerBackpack backpack = PlayerProfile.getBackpack(item);
                    if (backpack == null || !this.consumeJuice(p, backpack)) continue;
                    break;
                }
                return;
            }
        }
    }

    private boolean consumeJuice(Player p, PlayerBackpack backpack) {
        Inventory inv = backpack.getInventory();
        int slot = -1;
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.getType() != Material.POTION || !stack.hasItemMeta() || !stack.getItemMeta().hasDisplayName()) continue;
            slot = i;
            break;
        }
        if (slot >= 0) {
            PotionMeta im = (PotionMeta)inv.getItem(slot).getItemMeta();
            for (PotionEffect effect : im.getCustomEffects()) {
                p.addPotionEffect(effect);
            }
            p.setSaturation(6.0f);
            p.playSound(p.getLocation(), Sound.ENTITY_GENERIC_DRINK, 1.0f, 1.0f);
            inv.setItem(slot, null);
            backpack.markDirty();
            return true;
        }
        return false;
    }
}

