/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.multiblocks.MultiBlockMachine;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class Smeltery
extends MultiBlockMachine {
    private final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private final ItemSetting<Integer> fireBreakingChance = new ItemSetting<Integer>("fire-breaking-chance", 34);

    public Smeltery() {
        super(Categories.BASIC_MACHINES, SlimefunItems.SMELTERY, new ItemStack[]{null, new ItemStack(Material.NETHER_BRICK_FENCE), null, new ItemStack(Material.NETHER_BRICKS), new CustomItem(Material.DISPENSER, "Dispenser (Facing up)", new String[0]), new ItemStack(Material.NETHER_BRICKS), null, new ItemStack(Material.FLINT_AND_STEEL), null}, new ItemStack[]{SlimefunItems.IRON_DUST, new ItemStack(Material.IRON_INGOT)}, BlockFace.DOWN);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.recipes.size() - 1; i += 2) {
            if (Arrays.stream((Object[])this.recipes.get(i)).skip(1L).anyMatch(Objects::nonNull)) continue;
            items.add(((ItemStack[])this.recipes.get(i))[0]);
            items.add(((ItemStack[])this.recipes.get(i + 1))[0]);
        }
        return items;
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.DOWN);
        Dispenser disp = (Dispenser)dispBlock.getState();
        Inventory inv = disp.getInventory();
        List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
        for (int i = 0; i < inputs.size(); ++i) {
            if (!this.canCraft(inv, inputs, i)) continue;
            ItemStack output = RecipeType.getRecipeOutputList(this, inputs.get(i)).clone();
            if (Slimefun.hasUnlocked(p, output, true)) {
                Inventory outputInv = this.findOutputInventory(output, dispBlock, inv);
                if (outputInv != null) {
                    this.craft(p, dispBlock, b, inv, inputs.get(i), output, outputInv);
                } else {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.full-inventory", true);
                }
            }
            return;
        }
        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
    }

    private void craft(Player p, Block dispenser, Block b, Inventory inv, ItemStack[] recipe, ItemStack output, Inventory outputInv) {
        for (ItemStack removing : recipe) {
            if (removing == null) continue;
            InvUtils.removeItem(inv, removing.getAmount(), true, stack -> SlimefunUtils.isItemSimilar(stack, removing, true));
        }
        outputInv.addItem(new ItemStack[]{output});
        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
        p.getWorld().playEffect(b.getLocation(), Effect.MOBSPAWNER_FLAMES, 1);
        if (ThreadLocalRandom.current().nextInt(100) < this.fireBreakingChance.getValue()) {
            this.consumeFire(p, dispenser, b);
        }
    }

    private void consumeFire(Player p, Block dispenser, Block b) {
        Inventory chamber = this.findIgnitionChamber(dispenser);
        if (chamber != null) {
            if (chamber.contains(Material.FLINT_AND_STEEL)) {
                ItemStack item = chamber.getItem(chamber.first(Material.FLINT_AND_STEEL));
                ItemMeta meta = item.getItemMeta();
                ((Damageable)meta).setDamage(((Damageable)meta).getDamage() + 1);
                item.setItemMeta(meta);
                if (((Damageable)item.getItemMeta()).getDamage() >= item.getType().getMaxDurability()) {
                    item.setAmount(0);
                    p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                }
                p.getWorld().playSound(p.getLocation(), Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
            } else {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.ignition-chamber-no-flint", true);
                Block fire = b.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN);
                fire.getWorld().playEffect(fire.getLocation(), Effect.STEP_SOUND, (Object)fire.getType());
                fire.setType(Material.AIR);
            }
        } else {
            Block fire = b.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN);
            fire.getWorld().playEffect(fire.getLocation(), Effect.STEP_SOUND, (Object)fire.getType());
            fire.setType(Material.AIR);
        }
    }

    private boolean canCraft(Inventory inv, List<ItemStack[]> inputs, int i) {
        block0: for (ItemStack converting : inputs.get(i)) {
            if (converting == null) continue;
            for (int j = 0; j < inv.getContents().length; ++j) {
                if (j == inv.getContents().length - 1 && !SlimefunUtils.isItemSimilar(converting, inv.getContents()[j], true)) {
                    return false;
                }
                if (SlimefunUtils.isItemSimilar(inv.getContents()[j], converting, true)) continue block0;
            }
        }
        return true;
    }

    private Inventory findIgnitionChamber(Block b) {
        for (BlockFace face : this.faces) {
            if (b.getRelative(face).getType() != Material.DROPPER || !BlockStorage.check(b.getRelative(face), "IGNITION_CHAMBER")) continue;
            return ((Dropper)b.getRelative(face).getState()).getInventory();
        }
        return null;
    }
}

