/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.BackpackCrafter;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MagicWorkbench
extends BackpackCrafter {
    public MagicWorkbench() {
        super(Categories.BASIC_MACHINES, SlimefunItems.MAGIC_WORKBENCH, new ItemStack[]{null, null, null, null, null, null, new ItemStack(Material.BOOKSHELF), new ItemStack(Material.CRAFTING_TABLE), new ItemStack(Material.DISPENSER)}, new ItemStack[0], BlockFace.UP);
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block dispenser = this.locateDispenser(b);
        if (dispenser == null) {
            return;
        }
        Inventory inv = ((Dispenser)dispenser.getState()).getInventory();
        List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
        for (int i = 0; i < inputs.size(); ++i) {
            if (!this.isCraftable(inv, inputs.get(i))) continue;
            ItemStack output = RecipeType.getRecipeOutputList(this, inputs.get(i)).clone();
            if (Slimefun.hasUnlocked(p, output, true)) {
                this.craft(inv, dispenser, p, b, output);
            }
            return;
        }
        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
    }

    private void craft(Inventory inv, Block dispenser, Player p, Block b, ItemStack output) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            SlimefunItem sfItem = SlimefunItem.getByItem(output);
            if (sfItem instanceof SlimefunBackpack) {
                this.upgradeBackpack(p, inv, (SlimefunBackpack)sfItem, output);
            }
            for (int j = 0; j < 9; ++j) {
                if (inv.getContents()[j] == null || inv.getContents()[j].getType() == Material.AIR) continue;
                if (inv.getContents()[j].getAmount() > 1) {
                    inv.setItem(j, (ItemStack)new CustomItem(inv.getContents()[j], inv.getContents()[j].getAmount() - 1));
                    continue;
                }
                inv.setItem(j, null);
            }
            this.startAnimation(p, b, outputInv, output);
        } else {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }

    private void startAnimation(Player p, Block b, Inventory inv, ItemStack output) {
        for (int j = 0; j < 4; ++j) {
            int current = j;
            Bukkit.getScheduler().runTaskLater((Plugin)SlimefunPlugin.instance, () -> {
                p.getWorld().playEffect(b.getLocation(), Effect.MOBSPAWNER_FLAMES, 1);
                p.getWorld().playEffect(b.getLocation(), Effect.ENDER_SIGNAL, 1);
                if (current < 3) {
                    p.getWorld().playSound(b.getLocation(), Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, 1.0f, 1.0f);
                } else {
                    p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f);
                    inv.addItem(new ItemStack[]{output});
                }
            }, (long)j * 20L);
        }
    }

    private Block locateDispenser(Block b) {
        Block block = null;
        if (b.getRelative(1, 0, 0).getType() == Material.DISPENSER) {
            block = b.getRelative(1, 0, 0);
        } else if (b.getRelative(0, 0, 1).getType() == Material.DISPENSER) {
            block = b.getRelative(0, 0, 1);
        } else if (b.getRelative(-1, 0, 0).getType() == Material.DISPENSER) {
            block = b.getRelative(-1, 0, 0);
        } else if (b.getRelative(0, 0, -1).getType() == Material.DISPENSER) {
            block = b.getRelative(0, 0, -1);
        }
        return block;
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], true)) continue;
            if (SlimefunItem.getByItem(recipe[j]) instanceof SlimefunBackpack) {
                if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], false)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

