/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands;

import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

class SlimefunTabCompleter
implements TabCompleter {
    private static final int MAX_SUGGESTIONS = 80;
    private final SlimefunCommand command;

    public SlimefunTabCompleter(SlimefunCommand command) {
        this.command = command;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            return this.createReturnList(this.command.getTabArguments(), args[0]);
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give")) {
                return this.createReturnList(SlimefunPlugin.getRegistry().getEnabledSlimefunItemIds(), args[2]);
            }
            if (args[0].equalsIgnoreCase("research")) {
                Set researches = SlimefunPlugin.getRegistry().getResearchIds().keySet();
                LinkedList<String> suggestions = new LinkedList<String>();
                suggestions.add("all");
                suggestions.add("reset");
                for (NamespacedKey key : researches) {
                    suggestions.add(key.toString().toLowerCase(Locale.ROOT));
                }
                return this.createReturnList(suggestions, args[2]);
            }
            return null;
        }
        return null;
    }

    private List<String> createReturnList(List<String> list, String string) {
        if (string.equals("")) {
            return list;
        }
        String input = string.toLowerCase(Locale.ROOT);
        LinkedList<String> returnList = new LinkedList<String>();
        for (String item : list) {
            if (item.toLowerCase(Locale.ROOT).contains(input)) {
                returnList.add(item);
                if (returnList.size() < 80) continue;
                break;
            }
            if (!item.equalsIgnoreCase(input)) continue;
            return Collections.emptyList();
        }
        return returnList;
    }
}

