/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ImmutableItemMeta {
    private final Optional<String> displayName;
    private final Optional<List<String>> lore;
    private OptionalInt customModelData;
    private final Set<ItemFlag> itemFlags;
    private final Map<Enchantment, Integer> enchants;

    public ImmutableItemMeta(Supplier<ItemMeta> supplier) {
        this(supplier.get());
    }

    public ImmutableItemMeta(ItemStack item) {
        this(item.getItemMeta());
    }

    public ImmutableItemMeta(@NonNull ItemMeta meta) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        this.displayName = meta.hasDisplayName() ? Optional.of(meta.getDisplayName()) : Optional.empty();
        this.lore = meta.hasLore() ? Optional.of(meta.getLore()) : Optional.empty();
        try {
            this.customModelData = meta.hasCustomModelData() ? OptionalInt.of(meta.getCustomModelData()) : OptionalInt.empty();
        }
        catch (NoSuchMethodError x) {
            this.customModelData = OptionalInt.empty();
        }
        this.itemFlags = meta.getItemFlags();
        this.enchants = meta.getEnchants();
    }

    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    public Optional<List<String>> getLore() {
        return this.lore;
    }

    public OptionalInt getCustomModelData() {
        return this.customModelData;
    }

    public Set<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }
}

