/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CustomTextureService {
    private final Plugin plugin;
    private Config config;
    private boolean modified = false;

    public CustomTextureService(Plugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.config = new Config(this.plugin, "item-models.yml");
        this.config.getConfiguration().options().header("This file is used to assign items from Slimefun or any of its addons\nthe 'CustomModelData' NBT tag. This can be used in conjunction with a custom resource pack\nto give items custom textures.\n\nThere is no official Slimefun resource pack at the moment.");
        this.config.getConfiguration().options().copyHeader(true);
    }

    public void register(Iterable<SlimefunItem> items) {
        this.config.setDefaultValue("SLIMEFUN_GUIDE", 0);
        this.config.setDefaultValue("_UI_BACKGROUND", 0);
        this.config.setDefaultValue("_UI_BACK", 0);
        this.config.setDefaultValue("_UI_MENU", 0);
        this.config.setDefaultValue("_UI_SEARCH", 0);
        this.config.setDefaultValue("_UI_WIKI", 0);
        this.config.setDefaultValue("_UI_PREVIOUS_ACTIVE", 0);
        this.config.setDefaultValue("_UI_PREVIOUS_INACTIVE", 0);
        this.config.setDefaultValue("_UI_NEXT_ACTIVE", 0);
        this.config.setDefaultValue("_UI_NEXT_INACTIVE", 0);
        for (SlimefunItem item : items) {
            if (item == null || item.getID() == null) continue;
            this.config.setDefaultValue(item.getID(), 0);
            if (this.config.getInt(item.getID()) == 0) continue;
            this.modified = true;
        }
        this.config.save();
    }

    public String getVersion() {
        return this.config.getString("version");
    }

    public boolean isActive() {
        return this.modified;
    }

    public int getModelData(String id) {
        return this.config.getInt(id);
    }

    public void setTexture(ItemStack item, String id) {
        ItemMeta im = item.getItemMeta();
        this.setTexture(im, id);
        item.setItemMeta(im);
    }

    public void setTexture(ItemMeta im, String id) {
        int data = this.getModelData(id);
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            im.setCustomModelData(data == 0 ? null : Integer.valueOf(data));
        }
    }
}

